/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import org.apache.hadoop.hbase.procedure2.ProcedureFairRunQueues;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProcedureFairRunQueues {
    @Test
    public void testEmptyFairQueues() throws Exception {
        ProcedureFairRunQueues fairq = new ProcedureFairRunQueues(1);
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals(null, (Object)fairq.poll());
        }
    }

    @Test
    public void testFairQueues() throws Exception {
        ProcedureFairRunQueues fairq = new ProcedureFairRunQueues(1);
        TestRunQueue a = (TestRunQueue)fairq.add((Object)"A", (ProcedureFairRunQueues.FairObject)new TestRunQueue("A", 1));
        TestRunQueue b = (TestRunQueue)fairq.add((Object)"B", (ProcedureFairRunQueues.FairObject)new TestRunQueue("B", 1));
        TestRunQueue m = (TestRunQueue)fairq.add((Object)"M", (ProcedureFairRunQueues.FairObject)new TestRunQueue("M", 2));
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)a, (Object)fairq.poll());
            Assert.assertEquals((Object)b, (Object)fairq.poll());
            Assert.assertEquals((Object)m, (Object)fairq.poll());
            Assert.assertEquals((Object)m, (Object)fairq.poll());
        }
    }

    @Test
    public void testFairQueuesNotAvailable() throws Exception {
        int i;
        ProcedureFairRunQueues fairq = new ProcedureFairRunQueues(1);
        TestRunQueue a = (TestRunQueue)fairq.add((Object)"A", (ProcedureFairRunQueues.FairObject)new TestRunQueue("A", 1));
        TestRunQueue b = (TestRunQueue)fairq.add((Object)"B", (ProcedureFairRunQueues.FairObject)new TestRunQueue("B", 1));
        TestRunQueue m = (TestRunQueue)fairq.add((Object)"M", (ProcedureFairRunQueues.FairObject)new TestRunQueue("M", 2));
        m.setAvailable(false);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)a, (Object)fairq.poll());
            Assert.assertEquals((Object)b, (Object)fairq.poll());
        }
        m.setAvailable(true);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)m, (Object)fairq.poll());
            Assert.assertEquals((Object)m, (Object)fairq.poll());
            Assert.assertEquals((Object)a, (Object)fairq.poll());
            Assert.assertEquals((Object)b, (Object)fairq.poll());
        }
        b.setAvailable(false);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)m, (Object)fairq.poll());
            Assert.assertEquals((Object)m, (Object)fairq.poll());
            Assert.assertEquals((Object)a, (Object)fairq.poll());
        }
        Assert.assertEquals((Object)m, (Object)fairq.poll());
        m.setAvailable(false);
        Assert.assertEquals((Object)a, (Object)fairq.poll());
        Assert.assertEquals((Object)a, (Object)fairq.poll());
        b.setAvailable(true);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)b, (Object)fairq.poll());
            Assert.assertEquals((Object)a, (Object)fairq.poll());
        }
    }

    @Test
    public void testFairQueuesDelete() throws Exception {
        ProcedureFairRunQueues fairq = new ProcedureFairRunQueues(1);
        TestRunQueue a = (TestRunQueue)fairq.add((Object)"A", (ProcedureFairRunQueues.FairObject)new TestRunQueue("A", 1));
        TestRunQueue b = (TestRunQueue)fairq.add((Object)"B", (ProcedureFairRunQueues.FairObject)new TestRunQueue("B", 1));
        TestRunQueue m = (TestRunQueue)fairq.add((Object)"M", (ProcedureFairRunQueues.FairObject)new TestRunQueue("M", 2));
        Assert.assertEquals((Object)a, (Object)fairq.poll());
        Assert.assertEquals((Object)a, (Object)fairq.remove((Object)"A"));
        Assert.assertEquals((Object)b, (Object)fairq.poll());
        Assert.assertEquals((Object)b, (Object)fairq.remove((Object)"B"));
        Assert.assertEquals((Object)m, (Object)fairq.poll());
        Assert.assertEquals((Object)m, (Object)fairq.remove((Object)"M"));
        Assert.assertEquals(null, (Object)fairq.poll());
    }

    private static class TestRunQueue
    implements ProcedureFairRunQueues.FairObject {
        private final int priority;
        private final String name;
        private boolean available = true;

        public TestRunQueue(String name, int priority) {
            this.name = name;
            this.priority = priority;
        }

        public String toString() {
            return this.name;
        }

        private void setAvailable(boolean available) {
            this.available = available;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

