/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;

public class ProcedureTestingUtility {
    private static final Log LOG = LogFactory.getLog(ProcedureTestingUtility.class);

    private ProcedureTestingUtility() {
    }

    public static ProcedureStore createStore(Configuration conf, FileSystem fs, Path baseDir) throws IOException {
        return ProcedureTestingUtility.createWalStore(conf, fs, baseDir);
    }

    public static WALProcedureStore createWalStore(Configuration conf, FileSystem fs, Path logDir) throws IOException {
        return new WALProcedureStore(conf, fs, logDir, new WALProcedureStore.LeaseRecovery(){

            public void recoverFileLease(FileSystem fs, Path path) throws IOException {
            }
        });
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor) throws Exception {
        ProcedureTestingUtility.restart(procExecutor, null);
    }

    public static <TEnv> void restart(ProcedureExecutor<TEnv> procExecutor, Runnable beforeStartAction) throws Exception {
        ProcedureStore procStore = procExecutor.getStore();
        int storeThreads = procExecutor.getNumThreads();
        int execThreads = procExecutor.getNumThreads();
        procExecutor.stop();
        procExecutor.join();
        procStore.stop(false);
        if (beforeStartAction != null) {
            beforeStartAction.run();
        }
        procStore.start(storeThreads);
        procExecutor.start(execThreads);
    }

    public static <TEnv> void setKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.killBeforeStoreUpdate = value;
        LOG.warn((Object)("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate));
    }

    public static <TEnv> void setToggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.toggleKillBeforeStoreUpdate = value;
    }

    public static <TEnv> void toggleKillBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor) {
        if (procExecutor.testing == null) {
            procExecutor.testing = new ProcedureExecutor.Testing();
        }
        procExecutor.testing.killBeforeStoreUpdate = !procExecutor.testing.killBeforeStoreUpdate;
        LOG.warn((Object)("Set Kill before store update to: " + procExecutor.testing.killBeforeStoreUpdate));
    }

    public static <TEnv> void setKillAndToggleBeforeStoreUpdate(ProcedureExecutor<TEnv> procExecutor, boolean value) {
        ProcedureTestingUtility.setKillBeforeStoreUpdate(procExecutor, value);
        ProcedureTestingUtility.setToggleKillBeforeStoreUpdate(procExecutor, value);
    }

    public static <TEnv> long submitAndWait(ProcedureExecutor<TEnv> procExecutor, Procedure proc) {
        long procId = procExecutor.submitProcedure(proc);
        ProcedureTestingUtility.waitProcedure(procExecutor, procId);
        return procId;
    }

    public static <TEnv> void waitProcedure(ProcedureExecutor<TEnv> procExecutor, long procId) {
        while (!procExecutor.isFinished(procId) && procExecutor.isRunning()) {
            Threads.sleepWithoutInterrupt((long)250L);
        }
    }

    public static <TEnv> void waitNoProcedureRunning(ProcedureExecutor<TEnv> procExecutor) {
        int stableRuns = 0;
        while (stableRuns < 10) {
            if (procExecutor.getActiveExecutorCount() > 0 || procExecutor.getRunnableSet().size() > 0) {
                stableRuns = 0;
                Threads.sleepWithoutInterrupt((long)100L);
                continue;
            }
            ++stableRuns;
            Threads.sleepWithoutInterrupt((long)25L);
        }
    }

    public static <TEnv> void assertProcNotYetCompleted(ProcedureExecutor<TEnv> procExecutor, long procId) {
        Assert.assertFalse((String)"expected a running proc", (boolean)procExecutor.isFinished(procId));
        Assert.assertEquals(null, (Object)procExecutor.getResult(procId));
    }

    public static <TEnv> void assertProcNotFailed(ProcedureExecutor<TEnv> procExecutor, long procId) {
        ProcedureResult result = procExecutor.getResult(procId);
        Assert.assertTrue((String)"expected procedure result", (result != null ? 1 : 0) != 0);
        ProcedureTestingUtility.assertProcNotFailed(result);
    }

    public static void assertProcNotFailed(ProcedureResult result) {
        RemoteProcedureException exception = result.getException();
        String msg = exception != null ? exception.toString() : "no exception found";
        Assert.assertFalse((String)msg, (boolean)result.isFailed());
    }

    public static void assertIsAbortException(ProcedureResult result) {
        LOG.info((Object)result.getException());
        Assert.assertEquals((Object)true, (Object)result.isFailed());
        Throwable cause = result.getException().getCause();
        Assert.assertTrue((String)("expected abort exception, got " + cause), (boolean)(cause instanceof ProcedureAbortedException));
    }
}

