/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProcedureStoreTracker {
    private static final Log LOG = LogFactory.getLog(TestProcedureStoreTracker.class);

    @Test
    public void testSeqInsertAndDelete() {
        int j;
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Assert.assertTrue((boolean)tracker.isEmpty());
        boolean MIN_PROC = true;
        int MAX_PROC = 1024;
        for (i = 1; i < 1024; ++i) {
            tracker.insert((long)i);
            for (j = 1; j <= i; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)j));
            }
            for (j = i + 1; j < 1024; ++j) {
                Assert.assertTrue((tracker.isDeleted((long)j) != ProcedureStoreTracker.DeleteState.NO ? 1 : 0) != 0);
            }
        }
        for (i = 1; i < 1024; ++i) {
            tracker.delete((long)i);
            for (j = 1; j <= i; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted((long)j));
            }
            for (j = i + 1; j < 1024; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)j));
            }
        }
        Assert.assertTrue((boolean)tracker.isEmpty());
    }

    @Test
    public void testPartialTracker() {
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        tracker.setPartialFlag(true);
        Assert.assertTrue((boolean)tracker.isEmpty());
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(579L));
        tracker.setDeleted(1L, true);
        tracker.dump();
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(2L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(579L));
        tracker.setDeleted(579L, false);
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(2L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted(579L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(577L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(580L));
    }

    @Test
    public void testBasicCRUD() {
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Assert.assertTrue((boolean)tracker.isEmpty());
        TestProcedure[] procs = new TestProcedure[]{new TestProcedure(1L), new TestProcedure(2L), new TestProcedure(3L), new TestProcedure(4L), new TestProcedure(5L), new TestProcedure(6L)};
        tracker.insert((Procedure)procs[0], null);
        tracker.insert((Procedure)procs[1], new Procedure[]{procs[2], procs[3], procs[4]});
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        tracker.resetUpdates();
        Assert.assertFalse((boolean)tracker.isUpdated());
        for (i = 0; i < 4; ++i) {
            tracker.update((Procedure)procs[i]);
            Assert.assertFalse((boolean)tracker.isEmpty());
            Assert.assertFalse((boolean)tracker.isUpdated());
        }
        tracker.update((Procedure)procs[4]);
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        tracker.update((Procedure)procs[5]);
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        for (i = 0; i < 5; ++i) {
            tracker.delete(procs[i].getProcId());
            Assert.assertFalse((boolean)tracker.isEmpty());
            Assert.assertTrue((boolean)tracker.isUpdated());
        }
        tracker.delete(procs[5].getProcId());
        Assert.assertTrue((boolean)tracker.isEmpty());
    }

    @Test
    public void testRandLoad() {
        int NPROCEDURES = 2500;
        int NRUNS = 5000;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Random rand = new Random(1L);
        for (int i = 0; i < 5000; ++i) {
            Assert.assertTrue((boolean)tracker.isEmpty());
            int count = 0;
            while (count < 2500) {
                long procId = rand.nextLong();
                if (procId < 1L) continue;
                tracker.setDeleted(procId, i % 2 == 0);
                ++count;
            }
            tracker.clear();
        }
    }

    @Test
    public void testLoad() {
        int MAX_PROCS = 1000;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        for (int numProcs = 1; numProcs < 1000; ++numProcs) {
            for (int start = 1; start <= numProcs; ++start) {
                int i;
                Assert.assertTrue((boolean)tracker.isEmpty());
                LOG.debug((Object)("loading " + numProcs + " procs from start=" + start));
                for (i = start; i <= numProcs; ++i) {
                    tracker.setDeleted((long)i, false);
                }
                for (i = 1; i < start; ++i) {
                    tracker.setDeleted((long)i, false);
                }
                tracker.clear();
            }
        }
    }

    @Test
    public void testDelete() {
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        long[] procIds = new long[]{65L, 1L, 193L};
        for (i = 0; i < procIds.length; ++i) {
            tracker.insert(procIds[i]);
            tracker.dump();
        }
        for (i = 0; i < 256; ++i) {
            boolean hasProc = false;
            for (int j = 0; j < procIds.length; ++j) {
                if (procIds[j] != (long)i) continue;
                hasProc = true;
                break;
            }
            if (hasProc) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)i));
                continue;
            }
            Assert.assertEquals((String)("procId=" + i), (Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted((long)i));
        }
    }

    static class TestProcedure
    extends Procedure<Void> {
        public TestProcedure(long procId) {
            this.setProcId(procId);
        }

        protected Procedure[] execute(Void env) {
            return null;
        }

        protected void rollback(Void env) {
        }

        protected boolean abort(Void env) {
            return false;
        }

        protected void serializeStateData(OutputStream stream) {
        }

        protected void deserializeStateData(InputStream stream) {
        }
    }
}

