/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.junit.Assert;

public class TestRowDataSimple
extends BaseTestRowData {
    static byte[] rowA = Bytes.toBytes((String)"Arow");
    static byte[] rowB = Bytes.toBytes((String)"Brow");
    static byte[] cf = Bytes.toBytes((String)"fam");
    static byte[] cq0 = Bytes.toBytes((String)"cq0");
    static byte[] cq1 = Bytes.toBytes((String)"cq1tail");
    static byte[] cq2 = Bytes.toBytes((String)"dcq2");
    static byte[] v0 = Bytes.toBytes((String)"v0");
    static long ts = 55L;
    static List<KeyValue> d = Lists.newArrayList();

    @Override
    public List<KeyValue> getInputs() {
        return d;
    }

    @Override
    public void individualSearcherAssertions(CellSearcher searcher) {
        searcher.resetToBeforeFirstEntry();
        try {
            searcher.advance();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Cell first = searcher.current();
        Assert.assertTrue((boolean)CellComparator.equals((Cell)((Cell)d.get(0)), (Cell)first));
        Assert.assertTrue((boolean)searcher.positionAt((Cell)d.get(3)));
        Assert.assertTrue((boolean)CellComparator.equals((Cell)((Cell)d.get(3)), (Cell)searcher.current()));
        KeyValue between4And5 = new KeyValue(rowB, cf, cq1, ts - 2L, v0);
        Assert.assertFalse((boolean)searcher.positionAt((Cell)between4And5));
        CellScannerPosition p = searcher.positionAtOrBefore((Cell)between4And5);
        Assert.assertEquals((Object)CellScannerPosition.BEFORE, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(4))));
        p = searcher.positionAtOrAfter((Cell)between4And5);
        Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(5))));
        KeyValue beforeFirst = new KeyValue(Bytes.toBytes((String)"A"), cf, cq0, ts, v0);
        Assert.assertFalse((boolean)searcher.positionAt((Cell)beforeFirst));
        p = searcher.positionAtOrBefore((Cell)beforeFirst);
        Assert.assertEquals((Object)CellScannerPosition.BEFORE_FIRST, (Object)p);
        p = searcher.positionAtOrAfter((Cell)beforeFirst);
        Assert.assertEquals((Object)CellScannerPosition.AFTER, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)d.get(0))));
        Assert.assertEquals((Object)d.get(0), (Object)searcher.current());
        KeyValue afterLast = new KeyValue(Bytes.toBytes((String)"z"), cf, cq0, ts, v0);
        Assert.assertFalse((boolean)searcher.positionAt((Cell)afterLast));
        p = searcher.positionAtOrAfter((Cell)afterLast);
        Assert.assertEquals((Object)CellScannerPosition.AFTER_LAST, (Object)p);
        p = searcher.positionAtOrBefore((Cell)afterLast);
        Assert.assertEquals((Object)CellScannerPosition.BEFORE, (Object)p);
        Assert.assertTrue((boolean)CellComparator.equals((Cell)searcher.current(), (Cell)((Cell)CollectionUtils.getLast(d))));
    }

    static {
        d.add(new KeyValue(rowA, cf, cq0, ts, v0));
        d.add(new KeyValue(rowA, cf, cq1, ts, v0));
        d.add(new KeyValue(rowA, cf, cq2, ts, v0));
        d.add(new KeyValue(rowB, cf, cq0, ts, v0));
        d.add(new KeyValue(rowB, cf, cq1, ts, v0));
        d.add(new KeyValue(rowB, cf, cq2, ts, v0));
    }
}

