/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.timestamp;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.timestamp.TimestampDecoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.LongEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.timestamp.TestTimestampData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestTimestampEncoder {
    private TestTimestampData timestamps;
    private PrefixTreeBlockMeta blockMeta;
    private LongEncoder encoder;
    private byte[] bytes;
    private TimestampDecoder decoder;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return new TestTimestampData.InMemory().getAllAsObjectArray();
    }

    public TestTimestampEncoder(TestTimestampData testTimestamps) throws IOException {
        this.timestamps = testTimestamps;
        this.blockMeta = new PrefixTreeBlockMeta();
        this.blockMeta.setNumMetaBytes(0);
        this.blockMeta.setNumRowBytes(0);
        this.blockMeta.setNumQualifierBytes(0);
        this.encoder = new LongEncoder();
        for (Long ts : testTimestamps.getInputs()) {
            this.encoder.add(ts.longValue());
        }
        this.encoder.compile();
        this.blockMeta.setTimestampFields(this.encoder);
        this.bytes = this.encoder.getByteArray();
        this.decoder = new TimestampDecoder();
        this.decoder.initOnBlock(this.blockMeta, this.bytes);
    }

    @Test
    public void testCompressorMinimum() {
        Assert.assertEquals((long)this.timestamps.getMinimum(), (long)this.encoder.getMin());
    }

    @Test
    public void testCompressorRoundTrip() {
        long[] outputs = this.encoder.getSortedUniqueTimestamps();
        for (int i = 0; i < this.timestamps.getOutputs().size(); ++i) {
            long input = this.timestamps.getOutputs().get(i);
            long output = outputs[i];
            Assert.assertEquals((long)input, (long)output);
        }
    }

    @Test
    public void testReaderMinimum() {
        Assert.assertEquals((long)this.timestamps.getMinimum(), (long)this.decoder.getLong(0));
    }

    @Test
    public void testReaderRoundTrip() {
        for (int i = 0; i < this.timestamps.getOutputs().size(); ++i) {
            long input = this.timestamps.getOutputs().get(i);
            long output = this.decoder.getLong(i);
            Assert.assertEquals((long)input, (long)output);
        }
    }
}

