/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.row.TestRowData;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestRowEncoder {
    protected static int BLOCK_START = 7;
    protected TestRowData rows;
    protected List<KeyValue> inputKvs;
    protected boolean includeMemstoreTS = true;
    protected ByteArrayOutputStream os;
    protected PrefixTreeEncoder encoder;
    protected int totalBytes;
    protected PrefixTreeBlockMeta blockMetaWriter;
    protected byte[] outputBytes;
    protected ByteBuffer buffer;
    protected ByteArrayInputStream is;
    protected PrefixTreeBlockMeta blockMetaReader;
    protected byte[] inputBytes;
    protected PrefixTreeArraySearcher searcher;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        ArrayList parameters = Lists.newArrayList();
        for (TestRowData testRows : TestRowData.InMemory.getAll()) {
            parameters.add(new Object[]{testRows});
        }
        return parameters;
    }

    public TestRowEncoder(TestRowData testRows) {
        this.rows = testRows;
    }

    @Before
    public void compile() throws IOException {
        this.os = new ByteArrayOutputStream(0x100000);
        this.encoder = new PrefixTreeEncoder((OutputStream)this.os, this.includeMemstoreTS);
        this.inputKvs = this.rows.getInputs();
        for (KeyValue kv : this.inputKvs) {
            this.encoder.write((Cell)kv);
        }
        this.encoder.flush();
        this.totalBytes = this.encoder.getTotalBytes();
        this.blockMetaWriter = this.encoder.getBlockMeta();
        this.outputBytes = this.os.toByteArray();
        this.buffer = ByteBuffer.wrap(this.outputBytes);
        this.blockMetaReader = new PrefixTreeBlockMeta(this.buffer);
        this.searcher = new PrefixTreeArraySearcher(this.blockMetaReader, this.blockMetaReader.getRowTreeDepth(), this.blockMetaReader.getMaxRowLength(), this.blockMetaReader.getMaxQualifierLength(), this.blockMetaReader.getMaxTagsLength());
        this.searcher.initOnBlock(this.blockMetaReader, this.outputBytes, this.includeMemstoreTS);
    }

    @Test
    public void testEncoderOutput() throws IOException {
        Assert.assertEquals((long)this.totalBytes, (long)this.outputBytes.length);
        Assert.assertEquals((Object)this.blockMetaWriter, (Object)this.blockMetaReader);
    }

    @Test
    public void testForwardScanner() {
        int counter = -1;
        while (this.searcher.advance()) {
            KeyValue inputKv = this.rows.getInputs().get(++counter);
            KeyValue outputKv = KeyValueUtil.copyToNewKeyValue((Cell)this.searcher.current());
            this.assertKeyAndValueEqual((Cell)inputKv, (Cell)outputKv);
        }
        Assert.assertEquals((long)this.rows.getInputs().size(), (long)(counter + 1));
    }

    @Test
    public void testReverseScanner() {
        this.searcher.positionAfterLastCell();
        int counter = -1;
        while (this.searcher.previous()) {
            int oppositeIndex = this.rows.getInputs().size() - ++counter - 1;
            KeyValue inputKv = this.rows.getInputs().get(oppositeIndex);
            KeyValue outputKv = KeyValueUtil.copyToNewKeyValue((Cell)this.searcher.current());
            this.assertKeyAndValueEqual((Cell)inputKv, (Cell)outputKv);
        }
        Assert.assertEquals((long)this.rows.getInputs().size(), (long)(counter + 1));
    }

    @Test
    public void testReverseScannerWithJitter() {
        boolean foundCell;
        this.searcher.positionAfterLastCell();
        int counter = -1;
        while (foundCell = this.searcher.previous()) {
            ++counter;
            if (!this.searcher.isAfterLast()) {
                this.searcher.advance();
                this.searcher.previous();
            }
            int oppositeIndex = this.rows.getInputs().size() - counter - 1;
            KeyValue inputKv = this.rows.getInputs().get(oppositeIndex);
            KeyValue outputKv = KeyValueUtil.copyToNewKeyValue((Cell)this.searcher.current());
            this.assertKeyAndValueEqual((Cell)inputKv, (Cell)outputKv);
        }
        Assert.assertEquals((long)this.rows.getInputs().size(), (long)(counter + 1));
    }

    @Test
    public void testIndividualBlockMetaAssertions() {
        this.rows.individualBlockMetaAssertions(this.blockMetaReader);
    }

    protected void assertKeyAndValueEqual(Cell expected, Cell actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
        if (this.includeMemstoreTS) {
            Assert.assertEquals((long)expected.getMvccVersion(), (long)actual.getMvccVersion());
        }
        Assert.assertTrue((boolean)Bytes.equals((byte[])expected.getValueArray(), (int)expected.getValueOffset(), (int)expected.getValueLength(), (byte[])actual.getValueArray(), (int)actual.getValueOffset(), (int)actual.getValueLength()));
    }
}

