/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.builder;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.builder.TestTokenizerData;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerRowSearchResult;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestTokenizer {
    private List<byte[]> inputs;
    private Tokenizer builder;
    private List<byte[]> roundTripped;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return new TestTokenizerData.InMemory().getAllAsObjectArray();
    }

    public TestTokenizer(TestTokenizerData sortedByteArrays) {
        this.inputs = sortedByteArrays.getInputs();
        this.builder = new Tokenizer();
        for (byte[] array : this.inputs) {
            this.builder.addSorted((ByteRange)new SimpleByteRange(array));
        }
        this.roundTripped = this.builder.getArrays();
    }

    @Test
    public void testReaderRoundTrip() {
        Assert.assertEquals((long)this.inputs.size(), (long)this.roundTripped.size());
        Assert.assertTrue((boolean)Bytes.isSorted(this.roundTripped));
        Assert.assertTrue((boolean)Bytes.equals(this.inputs, this.roundTripped));
    }

    @Test
    public void testSearching() {
        for (byte[] input : this.inputs) {
            TokenizerRowSearchResult resultHolder = new TokenizerRowSearchResult();
            this.builder.getNode(resultHolder, input, 0, input.length);
            TokenizerNode n = resultHolder.getMatchingNode();
            byte[] output = n.getNewByteArray();
            Assert.assertTrue((boolean)Bytes.equals((byte[])input, (byte[])output));
        }
    }
}

