/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.column;

import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.column.TestColumnData;
import org.apache.hadoop.hbase.codec.prefixtree.decode.column.ColumnReader;
import org.apache.hadoop.hbase.codec.prefixtree.encode.column.ColumnSectionWriter;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.ColumnNodeType;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.ByteRangeUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.byterange.impl.ByteRangeTreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestColumnBuilder {
    protected TestColumnData columns;
    protected ByteRangeTreeSet columnSorter;
    protected List<ByteRange> sortedUniqueColumns;
    protected PrefixTreeBlockMeta blockMeta;
    protected Tokenizer builder;
    protected ColumnSectionWriter writer;
    protected byte[] bytes;
    protected byte[] buffer;
    protected ColumnReader reader;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return new TestColumnData.InMemory().getAllAsObjectArray();
    }

    public TestColumnBuilder(TestColumnData columns) {
        this.columns = columns;
        List<ByteRange> inputs = columns.getInputs();
        this.columnSorter = new ByteRangeTreeSet(inputs);
        this.sortedUniqueColumns = this.columnSorter.compile().getSortedRanges();
        ArrayList copies = ByteRangeUtils.copyToNewArrays(this.sortedUniqueColumns);
        Assert.assertTrue((boolean)Bytes.isSorted((Collection)copies));
        this.blockMeta = new PrefixTreeBlockMeta();
        this.blockMeta.setNumMetaBytes(0);
        this.blockMeta.setNumRowBytes(0);
        this.builder = new Tokenizer();
    }

    @Test
    public void testReaderRoundTrip() throws IOException {
        for (int i = 0; i < this.sortedUniqueColumns.size(); ++i) {
            ByteRange column = this.sortedUniqueColumns.get(i);
            this.builder.addSorted(column);
        }
        List builderOutputArrays = this.builder.getArrays();
        for (int i = 0; i < builderOutputArrays.size(); ++i) {
            byte[] inputArray = this.sortedUniqueColumns.get(i).deepCopyToNewArray();
            byte[] outputArray = (byte[])builderOutputArrays.get(i);
            boolean same = Bytes.equals((byte[])inputArray, (byte[])outputArray);
            Assert.assertTrue((boolean)same);
        }
        Assert.assertEquals((long)this.sortedUniqueColumns.size(), (long)builderOutputArrays.size());
        this.writer = new ColumnSectionWriter(this.blockMeta, this.builder, ColumnNodeType.QUALIFIER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer.compile().writeBytes((OutputStream)baos);
        this.bytes = baos.toByteArray();
        this.buffer = new byte[this.blockMeta.getMaxQualifierLength()];
        this.reader = new ColumnReader(this.buffer, ColumnNodeType.QUALIFIER);
        this.reader.initOnBlock(this.blockMeta, this.bytes);
        ArrayList builderNodes = Lists.newArrayList();
        this.builder.appendNodes((List)builderNodes, true, true);
        int i = 0;
        for (TokenizerNode builderNode : builderNodes) {
            if (!builderNode.hasOccurrences()) continue;
            Assert.assertEquals((long)1L, (long)builderNode.getNumOccurrences());
            int position = builderNode.getOutputArrayOffset();
            byte[] output = this.reader.populateBuffer(position).copyBufferToNewArray();
            boolean same = Bytes.equals((byte[])this.sortedUniqueColumns.get(i).deepCopyToNewArray(), (byte[])output);
            Assert.assertTrue((boolean)same);
            ++i;
        }
    }
}

