/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.builder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTreeDepth {
    @Test
    public void testSingleNode() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a"});
        this.testInternal(inputs, 1);
    }

    @Test
    public void testSimpleBranch() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "aa", "ab"});
        this.testInternal(inputs, 2);
    }

    @Test
    public void testEmptyRoot() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "b"});
        this.testInternal(inputs, 2);
    }

    @Test
    public void testRootAsNub() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "aa"});
        this.testInternal(inputs, 2);
    }

    @Test
    public void testRootAsNubPlusNub() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "aa", "aaa"});
        this.testInternal(inputs, 3);
    }

    @Test
    public void testEmptyRootPlusNub() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "aa", "b"});
        this.testInternal(inputs, 3);
    }

    @Test
    public void testSplitDistantAncestor() {
        ArrayList inputs = Lists.newArrayList((Object[])new String[]{"a", "ac", "acd", "b"});
        this.testInternal(inputs, 4);
    }

    protected void testInternal(List<String> inputs, int expectedTreeDepth) {
        Tokenizer builder = new Tokenizer();
        for (String s : inputs) {
            SimpleByteRange b = new SimpleByteRange(Bytes.toBytes((String)s));
            builder.addSorted((ByteRange)b);
        }
        Assert.assertEquals((long)1L, (long)builder.getRoot().getNodeDepth());
        Assert.assertEquals((long)expectedTreeDepth, (long)builder.getTreeDepth());
    }
}

