/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.keyvalue;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.codec.prefixtree.row.TestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataRandomKeyValuesWithTags;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataTrivialWithTags;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={SmallTests.class})
@RunWith(value=Parameterized.class)
public class TestKeyValueTool {
    private TestRowData rows;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        new TestRowData.InMemory();
        return TestRowData.InMemory.getAllAsObjectArray();
    }

    public TestKeyValueTool(TestRowData testRows) {
        this.rows = testRows;
    }

    @Test
    public void testRoundTripToBytes() {
        if (this.rows instanceof TestRowDataTrivialWithTags || this.rows instanceof TestRowDataRandomKeyValuesWithTags) {
            return;
        }
        List<KeyValue> kvs = this.rows.getInputs();
        ByteBuffer bb = KeyValueTestUtil.toByteBufferAndRewind(kvs, (boolean)false);
        List roundTrippedKvs = KeyValueTestUtil.rewindThenToList((ByteBuffer)bb, (boolean)false, (boolean)false);
        Assert.assertArrayEquals((Object[])kvs.toArray(), (Object[])roundTrippedKvs.toArray());
    }
}

