/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeTestConstants;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.hbase.util.byterange.impl.ByteRangeTreeSet;
import org.junit.Assert;

public class TestRowDataExerciseFInts
extends BaseTestRowData {
    static List<ByteRange> rows;
    static List<String> cols;
    static long ts;
    static int MAX_VALUE;
    static List<KeyValue> kvs;

    @Override
    public List<KeyValue> getInputs() {
        return kvs;
    }

    @Override
    public void individualBlockMetaAssertions(PrefixTreeBlockMeta blockMeta) {
        Assert.assertTrue((blockMeta.getNextNodeOffsetWidth() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((blockMeta.getQualifierOffsetWidth() > 1 ? 1 : 0) != 0);
    }

    static {
        ArrayList<String> rowStrings = new ArrayList<String>();
        rowStrings.add("com.edsBlog/directoryAa/pageAaa");
        rowStrings.add("com.edsBlog/directoryAa/pageBbb");
        rowStrings.add("com.edsBlog/directoryAa/pageCcc");
        rowStrings.add("com.edsBlog/directoryAa/pageDdd");
        rowStrings.add("com.edsBlog/directoryBb/pageEee");
        rowStrings.add("com.edsBlog/directoryBb/pageFff");
        rowStrings.add("com.edsBlog/directoryBb/pageGgg");
        rowStrings.add("com.edsBlog/directoryBb/pageHhh");
        rowStrings.add("com.isabellasBlog/directoryAa/pageAaa");
        rowStrings.add("com.isabellasBlog/directoryAa/pageBbb");
        rowStrings.add("com.isabellasBlog/directoryAa/pageCcc");
        rowStrings.add("com.isabellasBlog/directoryAa/pageDdd");
        rowStrings.add("com.isabellasBlog/directoryBb/pageEee");
        rowStrings.add("com.isabellasBlog/directoryBb/pageFff");
        rowStrings.add("com.isabellasBlog/directoryBb/pageGgg");
        rowStrings.add("com.isabellasBlog/directoryBb/pageHhh");
        ByteRangeTreeSet ba = new ByteRangeTreeSet();
        for (String row : rowStrings) {
            ba.add((ByteRange)new SimpleByteRange(Bytes.toBytes((String)row)));
        }
        rows = ba.compile().getSortedRanges();
        cols = Lists.newArrayList();
        cols.add("Chrome");
        cols.add("Chromeb");
        cols.add("Firefox");
        cols.add("InternetExplorer");
        cols.add("Opera");
        cols.add("Safari");
        cols.add("Z1stBrowserWithHuuuuuuuuuuuugeQualifier");
        cols.add("Z2ndBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z3rdBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z4thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z5thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z6thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z7thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z8thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        cols.add("Z9thBrowserWithEvenBiggerQualifierMoreMoreMoreMoreMore");
        ts = 1234567890L;
        MAX_VALUE = 50;
        kvs = Lists.newArrayList();
        for (ByteRange row : rows) {
            for (String col : cols) {
                KeyValue kv = new KeyValue(row.deepCopyToNewArray(), PrefixTreeTestConstants.TEST_CF, Bytes.toBytes((String)col), ts, KeyValue.Type.Put, Bytes.toBytes((String)"VALUE"));
                kvs.add(kv);
            }
        }
    }
}

