/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeSeeker;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.util.ByteBufferUtils;

@InterfaceAudience.Private
public class PrefixTreeCodec
implements DataBlockEncoder {
    public void encodeKeyValues(ByteBuffer in, HFileBlockEncodingContext blkEncodingCtx) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the " + "encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding();
        DataOutputStream dataOut = encodingCtx.getOutputStreamForEncoder();
        this.internalEncodeKeyValues(dataOut, in, encodingCtx.getHFileContext().isIncludesMvcc(), encodingCtx.getHFileContext().isIncludesTags());
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalEncodeKeyValues(DataOutputStream encodedOutputStream, ByteBuffer rawKeyValues, boolean includesMvccVersion, boolean includesTag) throws IOException {
        rawKeyValues.rewind();
        PrefixTreeEncoder builder = EncoderFactory.checkOut(encodedOutputStream, includesMvccVersion);
        try {
            KeyValue kv;
            while ((kv = KeyValueUtil.nextShallowCopy((ByteBuffer)rawKeyValues, (boolean)includesMvccVersion, (boolean)includesTag)) != null) {
                builder.write((Cell)kv);
            }
            builder.flush();
        }
        finally {
            EncoderFactory.checkIn(builder);
        }
    }

    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext decodingCtx) throws IOException {
        return this.decodeKeyValues(source, 0, 0, decodingCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer decodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDecodingContext decodingCtx) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer sourceAsBuffer = ByteBufferUtils.drainInputStreamToBuffer((InputStream)source);
        sourceAsBuffer.mark();
        PrefixTreeBlockMeta blockMeta = new PrefixTreeBlockMeta(sourceAsBuffer);
        sourceAsBuffer.rewind();
        int numV1BytesWithHeader = allocateHeaderLength + blockMeta.getNumKeyValueBytes();
        byte[] keyValueBytesWithHeader = new byte[numV1BytesWithHeader];
        ByteBuffer result = ByteBuffer.wrap(keyValueBytesWithHeader);
        result.rewind();
        PrefixTreeArraySearcher searcher = null;
        try {
            boolean includesMvcc = decodingCtx.getHFileContext().isIncludesMvcc();
            searcher = DecoderFactory.checkOut(sourceAsBuffer, includesMvcc);
            while (searcher.advance()) {
                KeyValue currentCell = KeyValueUtil.copyToNewKeyValue((Cell)searcher.current());
                int offset = result.arrayOffset() + result.position();
                System.arraycopy(currentCell.getBuffer(), currentCell.getOffset(), result.array(), offset, currentCell.getLength());
                int keyValueLength = KeyValueUtil.length((Cell)currentCell);
                ByteBufferUtils.skip((ByteBuffer)result, (int)keyValueLength);
                offset += keyValueLength;
                if (!includesMvcc) continue;
                ByteBufferUtils.writeVLong((ByteBuffer)result, (long)currentCell.getMvccVersion());
            }
            result.position(result.limit());
            byteBuffer = result;
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn(searcher);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getFirstKeyInBlock(ByteBuffer block) {
        block.rewind();
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut(block, true);
            if (!searcher.positionAtFirstCell()) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = KeyValueUtil.copyKeyToNewByteBuffer((Cell)searcher.current());
            return byteBuffer;
        }
        finally {
            DecoderFactory.checkIn(searcher);
        }
    }

    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding, byte[] header, HFileContext meta) {
        if (DataBlockEncoding.PREFIX_TREE != encoding) {
            throw new IllegalArgumentException("only DataBlockEncoding.PREFIX_TREE supported");
        }
        return new HFileBlockDefaultEncodingContext(encoding, header, meta);
    }

    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    public DataBlockEncoder.EncodedSeeker createSeeker(KeyValue.KVComparator comparator, HFileBlockDecodingContext decodingCtx) {
        if (comparator instanceof KeyValue.RawBytesComparator) {
            throw new IllegalArgumentException("comparator must be KeyValue.KeyComparator");
        }
        if (comparator instanceof KeyValue.MetaComparator) {
            throw new IllegalArgumentException("DataBlockEncoding.PREFIX_TREE not compatible with hbase:meta table");
        }
        return new PrefixTreeSeeker(decodingCtx.getHFileContext().isIncludesMvcc());
    }
}

