/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.column.data;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.column.TestColumnData;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.hbase.util.byterange.impl.ByteRangeTreeSet;
import org.apache.hadoop.hbase.util.test.RedundantKVGenerator;

public class TestColumnDataRandom
implements TestColumnData {
    private List<ByteRange> inputs = Lists.newArrayList();
    private List<ByteRange> outputs = Lists.newArrayList();

    public TestColumnDataRandom(int numColumns) {
        RedundantKVGenerator generator = new RedundantKVGenerator();
        ByteRangeTreeSet sortedColumns = new ByteRangeTreeSet();
        List d = generator.generateTestKeyValues(numColumns);
        for (KeyValue col : d) {
            SimpleByteRange colRange = new SimpleByteRange(col.getQualifier());
            this.inputs.add((ByteRange)colRange);
            sortedColumns.add((ByteRange)colRange);
        }
        for (KeyValue col : sortedColumns.compile().getSortedRanges()) {
            this.outputs.add((ByteRange)col);
        }
    }

    @Override
    public List<ByteRange> getInputs() {
        return this.inputs;
    }

    @Override
    public List<ByteRange> getOutputs() {
        return this.outputs;
    }
}

