/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.jni.MutationProxy;
import org.apache.hadoop.hbase.jni.PutProxy;

public final class TableProxy {
    protected HTable table_;

    public TableProxy(Configuration conf, String name) throws IOException {
        this.table_ = new HTable(conf, name);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.table_.setAutoFlushTo(autoFlush);
    }

    public void close() throws IOException {
        this.table_.close();
    }

    public void flushCommits() throws IOException {
        this.table_.flushCommits();
    }

    public void put(List<PutProxy> putProxies) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(putProxies.size());
        for (PutProxy putProxy : putProxies) {
            puts.add((Put)putProxy.toHBaseMutation());
        }
        this.table_.put(puts);
    }

    @Deprecated
    public Object[] batch(List<MutationProxy> mutations) throws InterruptedException, IOException {
        ArrayList<Mutation> actions = new ArrayList<Mutation>(mutations.size());
        for (MutationProxy mutation : mutations) {
            actions.add(mutation.toHBaseMutation());
        }
        return this.table_.batch(actions);
    }
}

