/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.io.IOException;
import org.apache.hadoop.hbase.jni.ClientProxy;
import org.apache.hadoop.hbase.jni.RowProxy;
import org.apache.hadoop.hbase.jni.ScannerCloseCallback;
import org.apache.hadoop.hbase.jni.ScannerNextCallback;
import org.hbase.async.Scanner;

public class ScannerProxy
extends RowProxy {
    private ClientProxy clientProxy_ = null;
    private Scanner scanner_ = null;
    private byte[] endRow_ = null;
    private int maxNumRows_ = -1;
    private int numVersions_ = -1;

    ScannerProxy(ClientProxy clientProxy) {
        this.clientProxy_ = clientProxy;
    }

    private void initScanner() {
        this.scanner_ = this.clientProxy_.newScanner(this.getTable());
        if (this.row_ != null) {
            this.scanner_.setStartKey(this.row_);
        }
        if (this.endRow_ != null) {
            this.scanner_.setStopKey(this.endRow_);
        }
        if (this.maxNumRows_ != -1) {
            this.scanner_.setMaxNumRows(this.maxNumRows_);
        }
        if (this.numVersions_ != -1) {
            this.scanner_.setMaxVersions(this.numVersions_);
        }
    }

    public void next(long callback, long scanner, long extra) throws IOException {
        if (this.scanner_ == null) {
            this.initScanner();
        }
        this.scanner_.nextRows().addBoth(new ScannerNextCallback(this, callback, scanner, extra));
    }

    public void close(long callback, long scanner, long extra) throws IOException {
        this.scanner_.close().addBoth(new ScannerCloseCallback(callback, scanner, extra));
    }

    public void setMaxNumRows(int maxNumRows) {
        this.maxNumRows_ = maxNumRows;
    }

    public void setNumVersions(int numVersions) {
        this.numVersions_ = numVersions;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow_ = endRow;
    }
}

