/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;

public class ResultProxy {
    protected ArrayList<KeyValue> kvList;
    private byte[] namespace;
    private byte[] table;
    public static final Comparator<KeyValue> KV_COMPARATOR = new Comparator<KeyValue>(){

        @Override
        public int compare(KeyValue o1, KeyValue o2) {
            int d = Bytes.memcmp((byte[])o1.key(), (byte[])o2.key());
            if (d != 0) {
                return d;
            }
            d = Bytes.memcmp((byte[])o1.family(), (byte[])o2.family());
            if (d != 0) {
                return d;
            }
            d = Bytes.memcmp((byte[])o1.qualifier(), (byte[])o2.qualifier());
            if (d != 0) {
                return d;
            }
            d = Long.signum(o2.timestamp() - o1.timestamp());
            if (d != 0) {
                return d;
            }
            d = Bytes.memcmp((byte[])o1.value(), (byte[])o2.value());
            return d;
        }
    };

    public ResultProxy(byte[] table, byte[] namespace, ArrayList<KeyValue> kvList) {
        this.table = table;
        this.namespace = namespace;
        this.kvList = kvList;
    }

    byte[] getRowKey() {
        return this.kvList == null || this.kvList.size() == 0 ? null : this.kvList.get(0).key();
    }

    byte[] getFamily(int cellIndex) {
        if (this.kvList == null || this.kvList.size() <= cellIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.kvList.get(cellIndex).family();
    }

    byte[] getQualifier(int cellIndex) {
        if (this.kvList == null || this.kvList.size() <= cellIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.kvList.get(cellIndex).qualifier();
    }

    byte[] getValue(int cellIndex) {
        if (this.kvList == null || this.kvList.size() <= cellIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.kvList.get(cellIndex).value();
    }

    long getTS(int cellIndex) {
        if (this.kvList == null || this.kvList.size() <= cellIndex) {
            throw new IndexOutOfBoundsException();
        }
        return this.kvList.get(cellIndex).timestamp();
    }

    int getCellCount() {
        return this.kvList != null ? this.kvList.size() : 0;
    }

    byte[] getNamespace() {
        return this.namespace;
    }

    int getNamespaceLength() {
        return this.namespace == null ? 0 : this.namespace.length;
    }

    byte[] getTable() {
        return this.table;
    }

    int getTableLength() {
        return this.table == null ? 0 : this.table.length;
    }

    ArrayList<KeyValue> getKvList() {
        return this.kvList;
    }

    int indexOf(byte[] family, byte[] qualifier) {
        KeyValue searchTerm = new KeyValue(this.getRowKey(), family, qualifier, HBaseClient.EMPTY_ARRAY);
        int pos = Collections.binarySearch(this.kvList, searchTerm, KV_COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == this.kvList.size()) {
            return -1;
        }
        KeyValue kv = this.kvList.get(pos);
        return Bytes.equals((byte[])family, (byte[])kv.family()) && Bytes.equals((byte[])qualifier, (byte[])kv.qualifier()) ? pos : -1;
    }
}

