/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.jni.MutationCallbackHandler;
import org.apache.hadoop.hbase.jni.MutationProxy;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;

public class PutProxy
extends MutationProxy {
    public PutProxy(byte[] row) {
        this.row_ = row;
    }

    @Override
    public Mutation toHBaseMutation() {
        Put put = new Put(this.row_);
        put.setDurability(this.durability_);
        for (byte[] family : this.familyMap.keySet()) {
            List kvList = (List)this.familyMap.get(family);
            int numKVs = kvList.size();
            for (int i = 0; i < numKVs; ++i) {
                KeyValue kv = (KeyValue)kvList.get(i);
                put.add(kv.family(), kv.qualifier(), kv.timestamp(), kv.value());
            }
        }
        return put;
    }

    @Override
    public void send(HBaseClient client, MutationCallbackHandler<Object, Object> cbh) {
        Map<byte[], List<KeyValue>> familyMap = this.getFamilyMap();
        int numFamilies = familyMap.size();
        byte[][] families = new byte[numFamilies][];
        byte[][][] qualifiers = new byte[numFamilies][][];
        byte[][][] values = new byte[numFamilies][][];
        long[][] timestamps = new long[numFamilies][];
        int idx = 0;
        for (byte[] family : familyMap.keySet()) {
            families[idx] = family;
            List<KeyValue> kvList = familyMap.get(family);
            int numKVs = kvList.size();
            qualifiers[idx] = new byte[numKVs][];
            values[idx] = new byte[numKVs][];
            timestamps[idx] = new long[numKVs];
            for (int i = 0; i < numKVs; ++i) {
                KeyValue kv = kvList.get(i);
                qualifiers[idx][i] = kv.qualifier();
                values[idx][i] = kv.value();
                timestamps[idx][i] = kv.timestamp();
            }
            ++idx;
        }
        PutRequest put = new PutRequest(this.getTable(), this.getRow(), (byte[][])families, (byte[][][])qualifiers, (byte[][][])values, (long[][])timestamps);
        put.setDurable(this.getDurability() != Durability.SKIP_WAL);
        put.setBufferable(this.isBufferable());
        client.put(put).addBoth(cbh);
    }
}

