/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.jni.MutationCallbackHandler;
import org.apache.hadoop.hbase.jni.RowProxy;
import org.apache.hadoop.hbase.util.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;

public abstract class MutationProxy
extends RowProxy {
    protected Durability durability_ = Durability.USE_DEFAULT;
    protected boolean bufferable_ = false;
    protected Map<byte[], List<KeyValue>> familyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);

    public MutationProxy addColumn(byte[] family, byte[] qualifier, byte[] value) {
        return this.addColumn(family, qualifier, Long.MAX_VALUE, value);
    }

    public MutationProxy addColumn(byte[] family, byte[] qualifier, long ts, byte[] value) {
        List<KeyValue> list = this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>(0);
            this.familyMap.put(family, list);
        }
        list.add(new KeyValue(this.row_, family, qualifier == null ? HBaseClient.EMPTY_ARRAY : qualifier, ts, value == null ? HBaseClient.EMPTY_ARRAY : value));
        return this;
    }

    public Durability getDurability() {
        return this.durability_;
    }

    public void setDurability(int durability) {
        this.durability_ = Durability.values()[durability];
    }

    public boolean isBufferable() {
        return this.bufferable_;
    }

    public void setBufferable(boolean bufferable) {
        this.bufferable_ = bufferable;
    }

    public Map<byte[], List<KeyValue>> getFamilyMap() {
        return this.familyMap;
    }

    public abstract Mutation toHBaseMutation();

    public abstract void send(HBaseClient var1, MutationCallbackHandler<Object, Object> var2);
}

