/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.jni.GetCallbackHandler;
import org.apache.hadoop.hbase.jni.RowProxy;
import org.apache.hadoop.hbase.util.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;

public class GetProxy
extends RowProxy {
    static final ParseFilter parseFilter = new ParseFilter();
    private final Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    private Filter filter;
    private int maxVersions = 1;

    public GetProxy(byte[] row) {
        this.row_ = row;
    }

    public GetProxy addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            this.familyMap.put(family, set);
        }
        if (qualifier != null) {
            set.add(qualifier);
        }
        return this;
    }

    public GetProxy setFilter(String filter) {
        try {
            this.filter = parseFilter.parseFilterString(filter);
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public GetProxy setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    Filter getFilter() {
        return this.filter;
    }

    Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    int getMaxVersions() {
        return this.maxVersions;
    }

    public void send(HBaseClient client, GetCallbackHandler<Object, ArrayList<KeyValue>> cbh) {
        GetRequest getReq = new GetRequest(this.getTable(), this.getRow());
        Map<byte[], NavigableSet<byte[]>> familyMap = this.getFamilyMap();
        if (familyMap.size() != 0) {
            int numFamilies = familyMap.size();
            byte[][] families = new byte[numFamilies][];
            byte[][][] qualifiers = new byte[numFamilies][][];
            int idx = 0;
            for (byte[] family : familyMap.keySet()) {
                families[idx] = family;
                NavigableSet<byte[]> qualifierSet = familyMap.get(family);
                if (qualifierSet.size() == 0) {
                    qualifiers[idx] = null;
                } else {
                    qualifiers[idx] = new byte[qualifierSet.size()][];
                    int i = 0;
                    for (byte[] qualifier : qualifierSet) {
                        qualifiers[idx][i] = qualifier;
                        ++i;
                    }
                }
                ++idx;
            }
            getReq.families((byte[][])families);
            getReq.qualifiers((byte[][][])qualifiers);
        }
        getReq.maxVersions(this.getMaxVersions());
        client.get(getReq).addBoth(cbh);
    }
}

