/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.jni.MutationCallbackHandler;
import org.apache.hadoop.hbase.jni.MutationProxy;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;

public class DeleteProxy
extends MutationProxy {
    public DeleteProxy(byte[] row) {
        this.row_ = row;
    }

    @Override
    public void send(HBaseClient client, MutationCallbackHandler<Object, Object> cbh) {
        Map<byte[], List<KeyValue>> familyMap = this.getFamilyMap();
        int numFamilies = familyMap.size();
        DeleteRequest del = null;
        if (numFamilies > 0) {
            byte[][] families = new byte[numFamilies][];
            byte[][][] qualifiers = new byte[numFamilies][][];
            long[][] timestamps = new long[numFamilies][];
            int idx = 0;
            for (byte[] family : familyMap.keySet()) {
                families[idx] = family;
                List<KeyValue> kvList = familyMap.get(family);
                int numKVs = kvList.size();
                if (numKVs > 0) {
                    boolean hasQualifier = false;
                    qualifiers[idx] = new byte[numKVs][];
                    timestamps[idx] = new long[numKVs];
                    for (int i = 0; i < numKVs; ++i) {
                        KeyValue kv = kvList.get(i);
                        if (kv.qualifier().length <= 0) continue;
                        hasQualifier = true;
                        qualifiers[idx][i] = kv.qualifier();
                        timestamps[idx][i] = kv.timestamp();
                    }
                    if (!hasQualifier) {
                        qualifiers[idx] = null;
                        timestamps[idx] = null;
                    }
                }
                ++idx;
            }
            del = new DeleteRequest(this.getTable(), this.getRow(), (byte[][])families, (byte[][][])qualifiers, (long[][])timestamps, this.getTS());
        } else {
            del = new DeleteRequest(this.getTable(), this.getRow());
        }
        del.setDurable(this.getDurability() != Durability.SKIP_WAL);
        del.setBufferable(this.isBufferable());
        client.delete(del).addBoth(cbh);
    }

    @Override
    public Mutation toHBaseMutation() {
        return null;
    }
}

