/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.jni;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.jni.ClientShutdownCallback;
import org.apache.hadoop.hbase.jni.FlushCallbackHandler;
import org.apache.hadoop.hbase.jni.GetCallbackHandler;
import org.apache.hadoop.hbase.jni.GetProxy;
import org.apache.hadoop.hbase.jni.MutationCallbackHandler;
import org.apache.hadoop.hbase.jni.MutationProxy;
import org.hbase.async.HBaseClient;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;

public class ClientProxy
implements Closeable {
    private final HBaseClient client_;

    ClientProxy(Configuration conf) {
        String zkQuorum = conf.get("hbase.zookeeper.ensemble");
        String baseZNode = conf.get("zookeeper.znode.parent");
        this.client_ = new HBaseClient(zkQuorum, baseZNode);
    }

    Scanner newScanner(byte[] table) {
        return this.client_.newScanner(table);
    }

    public void sendMutation(MutationProxy mutationProxy, long callback, long client, long mutation, long extra) {
        mutationProxy.send(this.client_, new MutationCallbackHandler<Object, Object>(mutationProxy, callback, client, mutation, extra));
    }

    public void sendGet(GetProxy getProxy, long callback, long client, long get, long extra) {
        getProxy.send(this.client_, new GetCallbackHandler<Object, ArrayList<KeyValue>>(getProxy, callback, client, get, extra));
    }

    public void flush(long callback, long client, long extra) throws IOException {
        this.client_.flush().addBoth(new FlushCallbackHandler(callback, client, extra));
    }

    @Override
    public void close() throws IOException {
        this.close(0L, 0L, 0L);
    }

    public void close(long callback, long client, long extra) throws IOException {
        this.client_.shutdown().addBoth(new ClientShutdownCallback(callback, client, extra));
    }
}

