/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.TestImportTsv;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestImportTsv
implements Configurable,
Tool {
    private static final String NAME = IntegrationTestImportTsv.class.getSimpleName();
    protected static final Log LOG = LogFactory.getLog(IntegrationTestImportTsv.class);
    protected static final String simple_tsv = "row1\t1\tc1\tc2\nrow2\t1\tc1\tc2\nrow3\t1\tc1\tc2\nrow4\t1\tc1\tc2\nrow5\t1\tc1\tc2\nrow6\t1\tc1\tc2\nrow7\t1\tc1\tc2\nrow8\t1\tc1\tc2\nrow9\t1\tc1\tc2\nrow10\t1\tc1\tc2\n";
    protected static final Set<KeyValue> simple_expected = new TreeSet<KeyValue>((Comparator)KeyValue.COMPARATOR){
        private static final long serialVersionUID = 1L;
        {
            byte[] family = Bytes.toBytes((String)"d");
            for (String line : IntegrationTestImportTsv.simple_tsv.split("\n")) {
                String[] row = line.split("\t");
                byte[] key = Bytes.toBytes((String)row[0]);
                long ts = Long.parseLong(row[1]);
                byte[][] fields = new byte[][]{Bytes.toBytes((String)row[2]), Bytes.toBytes((String)row[3])};
                this.add(new KeyValue(key, family, fields[0], ts, KeyValue.Type.Put, fields[0]));
                this.add(new KeyValue(key, family, fields[1], ts, KeyValue.Type.Put, fields[1]));
            }
        }
    };
    protected static IntegrationTestingUtility util = null;

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        if (null == util) {
            util = new IntegrationTestingUtility();
        }
        util.initializeCluster(1);
        if (!util.isDistributedCluster()) {
            util.startMiniMapReduceCluster();
        }
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.restoreCluster();
        if (!util.isDistributedCluster()) {
            util.shutdownMiniMapReduceCluster();
        }
        util = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadIncrementalHFiles(Path hfiles, TableName tableName) throws Exception {
        String[] args = new String[]{hfiles.toString(), tableName.getNameAsString()};
        LOG.info((Object)String.format("Running LoadIncrememntalHFiles with args: %s", Arrays.asList(args)));
        Assert.assertEquals((String)"Loading HFiles failed.", (long)0L, (long)ToolRunner.run((Tool)new LoadIncrementalHFiles(new Configuration(this.getConf())), (String[])args));
        HTable table = null;
        Scan scan = new Scan(){
            {
                this.setCacheBlocks(false);
                this.setCaching(1000);
            }
        };
        try {
            table = new HTable(this.getConf(), tableName);
            Iterator resultsIt = table.getScanner(scan).iterator();
            Iterator<KeyValue> expectedIt = simple_expected.iterator();
            while (resultsIt.hasNext() && expectedIt.hasNext()) {
                Result r = (Result)resultsIt.next();
                for (Cell actual : r.rawCells()) {
                    Assert.assertTrue((String)"Ran out of expected values prematurely!", (boolean)expectedIt.hasNext());
                    KeyValue expected = expectedIt.next();
                    Assert.assertTrue((String)String.format("Scan produced surprising result. expected: <%s>, actual: %s", expected, actual), (KeyValue.COMPARATOR.compare((Cell)expected, actual) == 0 ? 1 : 0) != 0);
                }
            }
            Assert.assertFalse((String)"Did not consume all expected values.", (boolean)expectedIt.hasNext());
            Assert.assertFalse((String)"Did not consume all scan results.", (boolean)resultsIt.hasNext());
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }

    protected static void validateDeletedPartitionsFile(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.test.cluster.distributed", false)) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path partitionsFile = new Path(TotalOrderPartitioner.getPartitionFile((Configuration)conf));
        Assert.assertFalse((String)"Failed to clean up partitions file.", (boolean)fs.exists(partitionsFile));
    }

    @Test
    public void testGenerateAndLoad() throws Exception {
        LOG.info((Object)"Running test testGenerateAndLoad.");
        TableName table = TableName.valueOf((String)(NAME + "-" + UUID.randomUUID()));
        String cf = "d";
        Path hfiles = new Path(util.getDataTestDirOnTestFS(table.getNameAsString()), "hfiles");
        String[] args = new String[]{String.format("-D%s=%s", "importtsv.bulk.output", hfiles), String.format("-D%s=HBASE_ROW_KEY,HBASE_TS_KEY,%s:c1,%s:c2", "importtsv.columns", cf, cf), String.format("-D%s=false", TestImportTsv.DELETE_AFTER_LOAD_CONF), table.getNameAsString()};
        util.createTable(table, new String[]{cf});
        Tool t = TestImportTsv.doMROnTableTest((HBaseTestingUtility)util, (String)cf, (String)simple_tsv, (String[])args);
        this.doLoadIncrementalHFiles(hfiles, table);
        IntegrationTestImportTsv.validateDeletedPartitionsFile(t.getConf());
        util.deleteTable(table);
        util.cleanupDataTestDirOnTestFS(table.getNameAsString());
        LOG.info((Object)"testGenerateAndLoad completed successfully.");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 0) {
            System.err.println(String.format("%s [genericOptions]", NAME));
            System.err.println("  Runs ImportTsv integration tests against a distributed cluster.");
            System.err.println();
            GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        IntegrationTestImportTsv.provisionCluster();
        this.testGenerateAndLoad();
        IntegrationTestImportTsv.releaseCluster();
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        util = new IntegrationTestingUtility(conf);
        args = new GenericOptionsParser(conf, args).getRemainingArgs();
        int status = new IntegrationTestImportTsv().run(args);
        System.exit(status);
    }
}

