/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.HBaseAdmin;

public class MoveRandomRegionOfTableAction
extends Action {
    private final long sleepTime;
    private final TableName tableName;

    public MoveRandomRegionOfTableAction(TableName tableName) {
        this(-1L, tableName);
    }

    public MoveRandomRegionOfTableAction(long sleepTime, TableName tableName) {
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        LOG.info((Object)("Performing action: Move random region of table " + this.tableName));
        List regions = admin.getTableRegions(this.tableName);
        if (regions == null || regions.isEmpty()) {
            LOG.info((Object)("Table " + this.tableName + " doesn't have regions to move"));
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        LOG.debug((Object)("Unassigning region " + region.getRegionNameAsString()));
        admin.unassign(region.getRegionName(), false);
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

