/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;

public class ChangeVersionsAction
extends Action {
    private final TableName tableName;
    private Admin admin;
    private Random random;

    public ChangeVersionsAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        int versions = this.random.nextInt(3) + 1;
        for (HColumnDescriptor descriptor : columnDescriptors) {
            descriptor.setMinVersions(versions);
            descriptor.setMaxVersions(versions);
        }
        LOG.debug((Object)("Performing action: Changing versions on " + this.tableName.getNameAsString()));
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

