/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;

public class BatchRestartRsAction
extends RestartActionBaseAction {
    float ratio;

    public BatchRestartRsAction(long sleepTime, float ratio) {
        super(sleepTime);
        this.ratio = ratio;
    }

    @Override
    public void perform() throws Exception {
        LOG.info((Object)String.format("Performing action: Batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
        for (ServerName server : selectedServers) {
            LOG.info((Object)("Killing region server:" + server));
            this.cluster.killRegionServer(server);
        }
        for (ServerName server : selectedServers) {
            this.cluster.waitForRegionServerToStop(server, 60000L);
        }
        LOG.info((Object)("Killed " + selectedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
        this.sleep(this.sleepTime);
        for (ServerName server : selectedServers) {
            LOG.info((Object)("Starting region server:" + server.getHostname()));
            this.cluster.startRegionServer(server.getHostname());
        }
        for (ServerName server : selectedServers) {
            this.cluster.waitForRegionServerToStart(server.getHostname(), 60000L);
        }
        LOG.info((Object)("Started " + selectedServers.size() + " region servers. Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }
}

