/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngest
extends IntegrationTestBase {
    public static final char HIPHEN = '-';
    private static final int SERVER_COUNT = 4;
    private static final long DEFAULT_RUN_TIME = 1200000L;
    private static final long JUNIT_RUN_TIME = 600000L;
    private static final String RUN_TIME_KEY = "hbase.%s.runtime";
    protected static final Log LOG = LogFactory.getLog(IntegrationTestIngest.class);
    protected IntegrationTestingUtility util;
    protected HBaseCluster cluster;
    protected LoadTestTool loadTool;

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        LOG.debug((Object)"Initializing/checking cluster has 4 servers");
        this.util.initializeCluster(4);
        LOG.debug((Object)"Done initializing/checking cluster");
        this.cluster = this.util.getHBaseClusterInterface();
        this.deleteTableIfNecessary();
        this.loadTool = new LoadTestTool();
        this.loadTool.setConf(this.util.getConfiguration());
        this.initTable();
    }

    protected void initTable() throws IOException {
        int ret = this.loadTool.run(new String[]{"-tn", this.getTablename(), "-init_only"});
        Assert.assertEquals((String)"Failed to initialize LoadTestTool", (long)0L, (long)ret);
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        this.internalRunIngestTest(1200000L);
        return 0;
    }

    @Test
    public void testIngest() throws Exception {
        this.runIngestTest(600000L, 2500, 10, 1024, 10);
    }

    private void internalRunIngestTest(long runTime) throws Exception {
        this.runIngestTest(runTime, 2500, 10, 1024, 10);
    }

    @Override
    public String getTablename() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])LoadTestTool.COLUMN_FAMILY)});
    }

    private void deleteTableIfNecessary() throws IOException {
        if (this.util.getHBaseAdmin().tableExists(this.getTablename())) {
            this.util.deleteTable(Bytes.toBytes((String)this.getTablename()));
        }
    }

    protected void runIngestTest(long defaultRunTime, int keysPerServerPerIter, int colsPerKey, int recordSize, int writeThreads) throws Exception {
        LOG.info((Object)"Running ingest");
        LOG.info((Object)("Cluster size:" + this.util.getHBaseClusterInterface().getClusterStatus().getServersSize()));
        long start = System.currentTimeMillis();
        String runtimeKey = String.format(RUN_TIME_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, defaultRunTime);
        long startKey = 0L;
        long numKeys = this.getNumKeys(keysPerServerPerIter);
        while ((double)(System.currentTimeMillis() - start) < 0.9 * (double)runtime) {
            String errorMsg;
            LOG.info((Object)("Intended run time: " + runtime / 60000L + " min, left:" + (runtime - (System.currentTimeMillis() - start)) / 60000L + " min"));
            int ret = -1;
            ret = this.loadTool.run(this.getArgsForLoadTestTool("-write", String.format("%d:%d:%d", colsPerKey, recordSize, writeThreads), startKey, numKeys));
            if (0 != ret) {
                errorMsg = "Load failed with error code " + ret;
                LOG.error((Object)errorMsg);
                Assert.fail((String)errorMsg);
            }
            if (0 != (ret = this.loadTool.run(this.getArgsForLoadTestTool("-update", String.format("60:%d:1", writeThreads), startKey, numKeys)))) {
                errorMsg = "Update failed with error code " + ret;
                LOG.error((Object)errorMsg);
                Assert.fail((String)errorMsg);
            }
            if (0 != (ret = this.loadTool.run(this.getArgsForLoadTestTool("-read", "100:20", startKey, numKeys)))) {
                errorMsg = "Verification failed with error code " + ret;
                LOG.error((Object)errorMsg);
                Assert.fail((String)errorMsg);
            }
            startKey += numKeys;
        }
    }

    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-tn");
        args.add(this.getTablename());
        args.add(mode);
        args.add(modeSpecificArg);
        args.add("-start_key");
        args.add(String.valueOf(startKey));
        args.add("-num_keys");
        args.add(String.valueOf(numKeys));
        args.add("-skip_init");
        return args.toArray(new String[args.size()]);
    }

    private long getNumKeys(int keysPerServer) throws IOException {
        int numRegionServers = this.cluster.getClusterStatus().getServersSize();
        return keysPerServer * numRegionServers;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngest(), (String[])args);
        System.exit(ret);
    }
}

