/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public abstract class ClusterManager
extends Configured {
    protected static final Log LOG = LogFactory.getLog(ClusterManager.class);
    private static final String SIGKILL = "SIGKILL";
    private static final String SIGSTOP = "SIGSTOP";
    private static final String SIGCONT = "SIGCONT";

    public abstract void start(ServiceType var1, String var2) throws IOException;

    public abstract void stop(ServiceType var1, String var2) throws IOException;

    public abstract void restart(ServiceType var1, String var2) throws IOException;

    public abstract void signal(ServiceType var1, String var2, String var3) throws IOException;

    public void kill(ServiceType service, String hostname) throws IOException {
        this.signal(service, SIGKILL, hostname);
    }

    public void suspend(ServiceType service, String hostname) throws IOException {
        this.signal(service, SIGSTOP, hostname);
    }

    public void resume(ServiceType service, String hostname) throws IOException {
        this.signal(service, SIGCONT, hostname);
    }

    public abstract boolean isRunning(ServiceType var1, String var2) throws IOException;

    public static enum ServiceType {
        HADOOP_NAMENODE("namenode"),
        HADOOP_DATANODE("datanode"),
        HADOOP_JOBTRACKER("jobtracker"),
        HADOOP_TASKTRACKER("tasktracker"),
        HBASE_MASTER("master"),
        HBASE_REGIONSERVER("regionserver");

        private String name;

        private ServiceType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

