/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.BatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.util.Shell;

public class RollingBatchRestartRsAction
extends BatchRestartRsAction {
    private static Log LOG = LogFactory.getLog(RollingBatchRestartRsAction.class);

    public RollingBatchRestartRsAction(long sleepTime, float ratio) {
        super(sleepTime, ratio);
    }

    @Override
    public void perform() throws Exception {
        LOG.info((Object)String.format("Performing action: Rolling batch restarting %d%% of region servers", (int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
        LinkedList<ServerName> serversToBeKilled = new LinkedList<ServerName>(selectedServers);
        LinkedList<ServerName> deadServers = new LinkedList<ServerName>();
        while (!serversToBeKilled.isEmpty() || !deadServers.isEmpty()) {
            ServerName server;
            boolean action = true;
            action = serversToBeKilled.isEmpty() || deadServers.isEmpty() ? deadServers.isEmpty() : RandomUtils.nextBoolean();
            if (action) {
                server = (ServerName)serversToBeKilled.remove();
                try {
                    this.killRs(server);
                }
                catch (Shell.ExitCodeException e) {
                    LOG.info((Object)("Problem killing but presume successful; code=" + e.getExitCode()), (Throwable)e);
                }
                deadServers.add(server);
            } else {
                try {
                    server = (ServerName)deadServers.remove();
                    this.startRs(server);
                }
                catch (Shell.ExitCodeException e) {
                    LOG.info((Object)("Problem starting, will retry; code=" + e.getExitCode()), (Throwable)e);
                }
            }
            this.sleep(RandomUtils.nextInt((int)((int)this.sleepTime)));
        }
    }

    public static void main(String[] args) throws Exception {
        RollingBatchRestartRsAction action = new RollingBatchRestartRsAction(1L, 1.0f){
            private int invocations = 0;

            @Override
            protected ServerName[] getCurrentServers() throws IOException {
                int count = 4;
                ArrayList<ServerName> serverNames = new ArrayList<ServerName>(4);
                for (int i = 0; i < 4; ++i) {
                    serverNames.add(ServerName.valueOf((String)(i + ".example.org"), (int)i, (long)i));
                }
                return serverNames.toArray(new ServerName[serverNames.size()]);
            }

            @Override
            protected void killRs(ServerName server) throws IOException {
                LOG.info((Object)("Killed " + server));
                if (this.invocations++ % 3 == 0) {
                    throw new Shell.ExitCodeException(-1, "Failed");
                }
            }

            @Override
            protected void startRs(ServerName server) throws IOException {
                LOG.info((Object)("Started " + server));
                if (this.invocations++ % 3 == 0) {
                    throw new Shell.ExitCodeException(-1, "Failed");
                }
            }
        };
        action.perform();
    }
}

