/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.RestartActionBaseAction;
import org.apache.hadoop.hbase.client.HTable;

public class RestartRsHoldingTableAction
extends RestartActionBaseAction {
    private final String tableName;

    public RestartRsHoldingTableAction(long sleepTime, String tableName) {
        super(sleepTime);
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        HTable table = null;
        try {
            Configuration conf = this.context.getHBaseIntegrationTestingUtility().getConfiguration();
            table = new HTable(conf, this.tableName);
        }
        catch (IOException e) {
            LOG.debug((Object)"Error creating HTable used to get list of region locations.", (Throwable)e);
            return;
        }
        Collection serverNames = table.getRegionLocations().values();
        ServerName[] nameArray = serverNames.toArray(new ServerName[serverNames.size()]);
        this.restartRs(nameArray[RandomUtils.nextInt((int)nameArray.length)], this.sleepTime);
    }
}

