/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class FlushTableAction
extends Action {
    private final byte[] tableNameBytes;
    private final long sleepTime;
    private final String tableName;

    public FlushTableAction(String tableName) {
        this(-1, tableName);
    }

    public FlushTableAction(int sleepTime, String tableName) {
        this.tableNameBytes = Bytes.toBytes((String)tableName);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        LOG.info((Object)("Performing action: Flush table " + this.tableName));
        try {
            admin.flush(this.tableNameBytes);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Flush failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

