/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.ServerLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class Action {
    protected static Log LOG = LogFactory.getLog(Action.class);
    protected ActionContext context;
    protected HBaseCluster cluster;
    protected ClusterStatus initialStatus;
    protected ServerName[] initialServers;

    public void init(ActionContext context) throws IOException {
        this.context = context;
        this.cluster = context.getHBaseCluster();
        this.initialStatus = this.cluster.getInitialClusterStatus();
        Collection regionServers = this.initialStatus.getServers();
        this.initialServers = regionServers.toArray(new ServerName[regionServers.size()]);
    }

    public void perform() throws Exception {
    }

    protected ServerName[] getCurrentServers() throws IOException {
        Collection regionServers = this.cluster.getClusterStatus().getServers();
        if (regionServers == null || regionServers.size() <= 0) {
            return new ServerName[0];
        }
        return regionServers.toArray(new ServerName[regionServers.size()]);
    }

    protected void killMaster(ServerName server) throws IOException {
        LOG.info((Object)("Killing master:" + server));
        this.cluster.killMaster(server);
        this.cluster.waitForMasterToStop(server, 60000L);
        LOG.info((Object)("Killed master server:" + server));
    }

    protected void startMaster(ServerName server) throws IOException {
        LOG.info((Object)("Starting master:" + server.getHostname()));
        this.cluster.startMaster(server.getHostname());
        this.cluster.waitForActiveAndReadyMaster(60000L);
        LOG.info((Object)("Started master: " + server));
    }

    protected void killRs(ServerName server) throws IOException {
        LOG.info((Object)("Killing region server:" + server));
        this.cluster.killRegionServer(server);
        this.cluster.waitForRegionServerToStop(server, 60000L);
        LOG.info((Object)("Killed region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void startRs(ServerName server) throws IOException {
        LOG.info((Object)("Starting region server:" + server.getHostname()));
        this.cluster.startRegionServer(server.getHostname());
        this.cluster.waitForRegionServerToStart(server.getHostname(), 60000L);
        LOG.info((Object)("Started region server:" + server + ". Reported num of rs:" + this.cluster.getClusterStatus().getServersSize()));
    }

    protected void unbalanceRegions(ClusterStatus clusterStatus, List<ServerName> fromServers, List<ServerName> toServers, double fractionOfRegions) throws Exception {
        LinkedList<byte[]> victimRegions = new LinkedList<byte[]>();
        for (ServerName server : fromServers) {
            ServerLoad serverLoad = clusterStatus.getLoad(server);
            LinkedList regions = new LinkedList(serverLoad.getRegionsLoad().keySet());
            int victimRegionCount = (int)Math.ceil(fractionOfRegions * (double)regions.size());
            LOG.debug((Object)("Removing " + victimRegionCount + " regions from " + server.getServerName()));
            for (int i = 0; i < victimRegionCount; ++i) {
                int victimIx = RandomUtils.nextInt((int)regions.size());
                String regionId = HRegionInfo.encodeRegionName((byte[])((byte[])regions.remove(victimIx)));
                victimRegions.add(Bytes.toBytes((String)regionId));
            }
        }
        LOG.info((Object)("Moving " + victimRegions.size() + " regions from " + fromServers.size() + " servers to " + toServers.size() + " different servers"));
        HBaseAdmin admin = this.context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
        for (byte[] victimRegion : victimRegions) {
            int targetIx = RandomUtils.nextInt((int)toServers.size());
            admin.move(victimRegion, Bytes.toBytes((String)toServers.get(targetIx).getServerName()));
        }
    }

    protected void forceBalancer() throws Exception {
        HBaseAdmin admin = this.context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
        boolean result = admin.balancer();
        if (!result) {
            LOG.error((Object)"Balancer didn't succeed");
        }
    }

    public static class ActionContext {
        private IntegrationTestingUtility util;

        public ActionContext(IntegrationTestingUtility util) {
            this.util = util;
        }

        public IntegrationTestingUtility getHBaseIntegrationTestingUtility() {
            return this.util;
        }

        public HBaseCluster getHBaseCluster() {
            return this.util.getHBaseClusterInterface();
        }
    }
}

