/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.List;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.util.Bytes;

public class SplitRandomRegionOfTableAction
extends Action {
    private final byte[] tableNameBytes;
    private final long sleepTime;
    private final String tableName;

    public SplitRandomRegionOfTableAction(String tableName) {
        this(-1, tableName);
    }

    public SplitRandomRegionOfTableAction(int sleepTime, String tableName) {
        this.tableNameBytes = Bytes.toBytes((String)tableName);
        this.sleepTime = sleepTime;
        this.tableName = tableName;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        HBaseAdmin admin = util.getHBaseAdmin();
        LOG.info((Object)("Performing action: Split random region of table " + this.tableName));
        List regions = admin.getTableRegions(this.tableNameBytes);
        if (regions == null || regions.isEmpty()) {
            LOG.info((Object)("Table " + this.tableName + " doesn't have regions to split"));
            return;
        }
        HRegionInfo region = PolicyBasedChaosMonkey.selectRandomItem(regions.toArray(new HRegionInfo[regions.size()]));
        LOG.debug((Object)("Splitting region " + region.getRegionNameAsString()));
        try {
            admin.split(region.getRegionName());
        }
        catch (Exception ex) {
            LOG.warn((Object)("Split failed, might be caused by other chaos: " + ex.getMessage()));
        }
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

