/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.chaos.factories.MonkeyFactory;
import org.apache.hadoop.hbase.chaos.monkies.ChaosMonkey;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.junit.After;
import org.junit.Before;

public abstract class IntegrationTestBase
extends AbstractHBaseTool {
    public static final String LONG_OPT = "monkey";
    private static final Log LOG = LogFactory.getLog(IntegrationTestBase.class);
    protected IntegrationTestingUtility util;
    protected ChaosMonkey monkey;
    protected String monkeyToUse;

    public IntegrationTestBase() {
        this(null);
    }

    public IntegrationTestBase(String monkeyToUse) {
        this.monkeyToUse = monkeyToUse;
    }

    protected void addOptions() {
        this.addOptWithArg("m", LONG_OPT, "Which chaos monkey to run");
    }

    protected void processOptions(CommandLine cmd) {
        if (cmd.hasOption(LONG_OPT)) {
            this.monkeyToUse = cmd.getOptionValue(LONG_OPT);
        }
    }

    public Configuration getConf() {
        Configuration c = super.getConf();
        if (c == null && this.util != null) {
            c = this.conf = this.util.getConfiguration();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() throws Exception {
        this.setUp();
        int result = -1;
        try {
            result = this.runTestFromCommandLine();
        }
        finally {
            this.cleanUp();
        }
        return result;
    }

    @Before
    public void setUp() throws Exception {
        this.setUpCluster();
        this.setUpMonkey();
    }

    @After
    public void cleanUp() throws Exception {
        this.cleanUpMonkey();
        this.cleanUpCluster();
    }

    public void setUpMonkey() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        MonkeyFactory fact = MonkeyFactory.getFactory(this.monkeyToUse);
        if (fact == null) {
            fact = this.getDefaultMonkeyFactory();
        }
        this.monkey = fact.setUtil(this.util).setTableName(this.getTablename()).setColumnFamilies(this.getColumnFamilies()).build();
        this.monkey.start();
    }

    public void cleanUpMonkey() throws Exception {
        this.cleanUpMonkey("Ending test");
    }

    protected void cleanUpMonkey(String why) throws Exception {
        if (this.monkey != null && !this.monkey.isStopped()) {
            this.monkey.stop(why);
            this.monkey.waitForStop();
        }
    }

    protected IntegrationTestingUtility getTestingUtil(Configuration conf) {
        if (this.util == null) {
            this.util = conf == null ? new IntegrationTestingUtility() : new IntegrationTestingUtility(conf);
        }
        return this.util;
    }

    protected MonkeyFactory getDefaultMonkeyFactory() {
        return MonkeyFactory.getFactory(this.util.isDistributedCluster() ? "calm" : "slowDeterministic");
    }

    public abstract void setUpCluster() throws Exception;

    public void cleanUpCluster() throws Exception {
        LOG.debug((Object)"Restoring the cluster");
        this.util.restoreCluster();
        LOG.debug((Object)"Done restoring the cluster");
    }

    public abstract int runTestFromCommandLine() throws Exception;

    public abstract String getTablename();

    protected abstract Set<String> getColumnFamilies();
}

