/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestBigLinkedList
extends IntegrationTestBase {
    protected static final byte[] NO_KEY = new byte[1];
    protected static String TABLE_NAME_KEY = "IntegrationTestBigLinkedList.table";
    protected static String DEFAULT_TABLE_NAME = "IntegrationTestBigLinkedList";
    protected static byte[] FAMILY_NAME = Bytes.toBytes((String)"meta");
    protected static final byte[] COLUMN_PREV = Bytes.toBytes((String)"prev");
    protected static final byte[] COLUMN_CLIENT = Bytes.toBytes((String)"client");
    protected static final byte[] COLUMN_COUNT = Bytes.toBytes((String)"count");
    private static final String GENERATOR_NUM_ROWS_PER_MAP_KEY = "IntegrationTestBigLinkedList.generator.num_rows";
    private static final String GENERATOR_NUM_MAPPERS_KEY = "IntegrationTestBigLinkedList.generator.map.tasks";
    private static final String GENERATOR_WIDTH_KEY = "IntegrationTestBigLinkedList.generator.width";
    private static final String GENERATOR_WRAP_KEY = "IntegrationTestBigLinkedList.generator.wrap";
    protected int NUM_SLAVES_BASE = 3;
    private static final int MISSING_ROWS_TO_LOG = 50;
    private static final int WIDTH_DEFAULT = 1000000;
    private static final int WRAP_DEFAULT = 25;
    private static final int ROWKEY_LENGTH = 16;
    protected String toRun;
    protected String[] otherArgs;
    protected IntegrationTestingUtility util;

    static TableName getTableName(Configuration conf) {
        return TableName.valueOf((String)conf.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
    }

    private static CINode getCINode(Result result, CINode node) {
        node.key = Bytes.copy((byte[])result.getRow());
        node.prev = result.containsColumn(FAMILY_NAME, COLUMN_PREV) ? Bytes.copy((byte[])result.getValue(FAMILY_NAME, COLUMN_PREV)) : NO_KEY;
        node.count = result.containsColumn(FAMILY_NAME, COLUMN_COUNT) ? Bytes.toLong((byte[])result.getValue(FAMILY_NAME, COLUMN_COUNT)) : -1L;
        node.client = result.containsColumn(FAMILY_NAME, COLUMN_CLIENT) ? Bytes.toString((byte[])result.getValue(FAMILY_NAME, COLUMN_CLIENT)) : "";
        return node;
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        boolean isDistributed = this.util.isDistributedCluster();
        this.util.initializeCluster(isDistributed ? 1 : this.NUM_SLAVES_BASE);
        if (!isDistributed) {
            this.util.startMiniMapReduceCluster();
        }
        this.setConf(this.util.getConfiguration());
    }

    @Override
    public void cleanUpCluster() throws Exception {
        super.cleanUpCluster();
        if (this.util.isDistributedCluster()) {
            this.util.shutdownMiniMapReduceCluster();
        }
    }

    @Test
    public void testContinuousIngest() throws IOException, Exception {
        int ret = ToolRunner.run((Configuration)this.getTestingUtil(this.getConf()).getConfiguration(), (Tool)new Loop(), (String[])new String[]{"1", "1", "2000000", this.util.getDataTestDirOnTestFS("IntegrationTestBigLinkedList").toString(), "1"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void usage() {
        System.err.println("Usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " COMMAND [COMMAND options]");
        System.err.println("  where COMMAND is one of:");
        System.err.println("");
        System.err.println("  Generator                  A map only job that generates data.");
        System.err.println("  Verify                     A map reduce job that looks for holes");
        System.err.println("                             Look at the counts after running");
        System.err.println("                             REFERENCED and UNREFERENCED are ok");
        System.err.println("                             any UNDEFINED counts are bad. Do not");
        System.err.println("                             run at the same time as the Generator.");
        System.err.println("  Walker                     A standalong program that starts ");
        System.err.println("                             following a linked list and emits");
        System.err.println("                             timing info.");
        System.err.println("  Print                      A standalone program that prints nodes");
        System.err.println("                             in the linked list.");
        System.err.println("  Delete                     A standalone program that deletes a\u00b7");
        System.err.println("                             single node.");
        System.err.println("  Loop                       A program to Loop through Generator and");
        System.err.println("                             Verify steps");
        System.err.println("\t  ");
        System.err.flush();
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        String[] args = cmd.getArgs();
        if (args.length < 1) {
            this.printUsage();
            throw new RuntimeException("Incorrect Number of args.");
        }
        this.toRun = args[0];
        this.otherArgs = Arrays.copyOfRange(args, 1, args.length);
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        Configured tool = null;
        if (this.toRun.equals("Generator")) {
            tool = new Generator();
        } else if (this.toRun.equals("Verify")) {
            tool = new Verify();
        } else if (this.toRun.equals("Loop")) {
            Loop loop = new Loop();
            loop.it = this;
            tool = loop;
        } else if (this.toRun.equals("Walker")) {
            tool = new Walker();
        } else if (this.toRun.equals("Print")) {
            tool = new Print();
        } else if (this.toRun.equals("Delete")) {
            tool = new Delete();
        } else {
            this.usage();
            throw new RuntimeException("Unknown arg");
        }
        return ToolRunner.run((Configuration)this.getConf(), (Tool)tool, (String[])this.otherArgs);
    }

    @Override
    public String getTablename() {
        Configuration c = this.getConf();
        return c.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME);
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])FAMILY_NAME)});
    }

    private static void setJobConf(Job job, int numMappers, long numNodes, Integer width, Integer wrapMultiplier) {
        job.getConfiguration().setInt(GENERATOR_NUM_MAPPERS_KEY, numMappers);
        job.getConfiguration().setLong(GENERATOR_NUM_ROWS_PER_MAP_KEY, numNodes);
        if (width != null) {
            job.getConfiguration().setInt(GENERATOR_WIDTH_KEY, width.intValue());
        }
        if (wrapMultiplier != null) {
            job.getConfiguration().setInt(GENERATOR_WRAP_KEY, wrapMultiplier.intValue());
        }
    }

    public static void setJobScannerConf(Job job) {
        job.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        job.getConfiguration().setInt("hbase.mapreduce.log.scanner.rowcount", 100000);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestBigLinkedList(), (String[])args);
        System.exit(ret);
    }

    private static class Walker
    extends Configured
    implements Tool {
        private Walker() {
        }

        public int run(String[] args) throws IOException {
            Options options = new Options();
            options.addOption("n", "num", true, "number of queries");
            options.addOption("s", "start", true, "key to start at, binary string");
            options.addOption("l", "logevery", true, "log every N queries");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            long maxQueries = Long.MAX_VALUE;
            if (cmd.hasOption('n')) {
                maxQueries = Long.parseLong(cmd.getOptionValue("n"));
            }
            Random rand = new Random();
            boolean isSpecificStart = cmd.hasOption('s');
            byte[] startKey = isSpecificStart ? Bytes.toBytesBinary((String)cmd.getOptionValue('s')) : null;
            int logEvery = cmd.hasOption('l') ? Integer.parseInt(cmd.getOptionValue('l')) : 1;
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            long numQueries = 0L;
            while (!(numQueries >= maxQueries || numQueries != 0L && isSpecificStart)) {
                CINode node;
                if (!isSpecificStart) {
                    startKey = new byte[16];
                    rand.nextBytes(startKey);
                }
                if ((node = Walker.findStartNode(table, startKey)) == null && isSpecificStart) {
                    System.err.printf("Start node not found: %s \n", Bytes.toStringBinary((byte[])startKey));
                }
                ++numQueries;
                while (node != null && node.prev.length != NO_KEY.length && numQueries < maxQueries) {
                    byte[] prev = node.prev;
                    long t1 = System.currentTimeMillis();
                    node = this.getNode(prev, table, node);
                    long t2 = System.currentTimeMillis();
                    if (numQueries % (long)logEvery == 0L) {
                        System.out.printf("CQ %d: %d %s \n", numQueries, t2 - t1, Bytes.toStringBinary((byte[])prev));
                    }
                    ++numQueries;
                    if (node == null) {
                        System.err.printf("UNDEFINED NODE %s \n", Bytes.toStringBinary((byte[])prev));
                        continue;
                    }
                    if (node.prev.length != NO_KEY.length) continue;
                    System.err.printf("TERMINATING NODE %s \n", Bytes.toStringBinary((byte[])node.key));
                }
            }
            table.close();
            return 0;
        }

        private static CINode findStartNode(HTable table, byte[] startKey) throws IOException {
            Scan scan = new Scan();
            scan.setStartRow(startKey);
            scan.setBatch(1);
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            long t1 = System.currentTimeMillis();
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            long t2 = System.currentTimeMillis();
            scanner.close();
            if (result != null) {
                CINode node = IntegrationTestBigLinkedList.getCINode(result, new CINode());
                System.out.printf("FSR %d %s\n", t2 - t1, Bytes.toStringBinary((byte[])node.key));
                return node;
            }
            System.out.println("FSR " + (t2 - t1));
            return null;
        }

        private CINode getNode(byte[] row, HTable table, CINode node) throws IOException {
            Get get = new Get(row);
            get.addColumn(FAMILY_NAME, COLUMN_PREV);
            Result result = table.get(get);
            return IntegrationTestBigLinkedList.getCINode(result, node);
        }
    }

    private static class Delete
    extends Configured
    implements Tool {
        private Delete() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1) {
                System.out.println("Usage : " + Delete.class.getSimpleName() + " <node to delete>");
                return 0;
            }
            byte[] val = Bytes.toBytesBinary((String)args[0]);
            org.apache.hadoop.hbase.client.Delete delete = new org.apache.hadoop.hbase.client.Delete(val);
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            table.delete(delete);
            table.flushCommits();
            table.close();
            System.out.println("Delete successful");
            return 0;
        }
    }

    private static class Print
    extends Configured
    implements Tool {
        private Print() {
        }

        public int run(String[] args) throws Exception {
            Options options = new Options();
            options.addOption("s", "start", true, "start key");
            options.addOption("e", "end", true, "end key");
            options.addOption("l", "limit", true, "number to print");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            HTable table = new HTable(this.getConf(), IntegrationTestBigLinkedList.getTableName(this.getConf()));
            Scan scan = new Scan();
            scan.setBatch(10000);
            if (cmd.hasOption("s")) {
                scan.setStartRow(Bytes.toBytesBinary((String)cmd.getOptionValue("s")));
            }
            if (cmd.hasOption("e")) {
                scan.setStopRow(Bytes.toBytesBinary((String)cmd.getOptionValue("e")));
            }
            int limit = 0;
            limit = cmd.hasOption("l") ? Integer.parseInt(cmd.getOptionValue("l")) : 100;
            ResultScanner scanner = table.getScanner(scan);
            CINode node = new CINode();
            Result result = scanner.next();
            int count = 0;
            while (result != null && count++ < limit) {
                node = IntegrationTestBigLinkedList.getCINode(result, node);
                System.out.printf("%s:%s:%012d:%s\n", Bytes.toStringBinary((byte[])node.key), Bytes.toStringBinary((byte[])node.prev), node.count, node.client);
                result = scanner.next();
            }
            scanner.close();
            table.close();
            return 0;
        }
    }

    static class Loop
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Loop.class);
        IntegrationTestBigLinkedList it;

        Loop() {
        }

        protected void runGenerator(int numMappers, long numNodes, String outputDir, Integer width, Integer wrapMuplitplier) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path generatorOutput = new Path(outputPath, uuid.toString());
            Generator generator = new Generator();
            generator.setConf(this.getConf());
            int retCode = generator.run(numMappers, numNodes, generatorOutput, width, wrapMuplitplier);
            if (retCode > 0) {
                throw new RuntimeException("Generator failed with return code: " + retCode);
            }
        }

        protected void runVerify(String outputDir, int numReducers, long expectedNumNodes) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path iterationOutput = new Path(outputPath, uuid.toString());
            Verify verify = new Verify();
            verify.setConf(this.getConf());
            int retCode = verify.run(iterationOutput, numReducers);
            if (retCode > 0) {
                throw new RuntimeException("Verify.run failed with return code: " + retCode);
            }
            if (!verify.verify(expectedNumNodes)) {
                throw new RuntimeException("Verify.verify failed");
            }
            LOG.info((Object)("Verify finished with succees. Total nodes=" + expectedNumNodes));
        }

        public int run(String[] args) throws Exception {
            if (args.length < 5) {
                System.err.println("Usage: Loop <num iterations> <num mappers> <num nodes per mapper> <output dir> <num reducers> [<width> <wrap multiplier>]");
                return 1;
            }
            LOG.info((Object)("Running Loop with args:" + Arrays.deepToString(args)));
            int numIterations = Integer.parseInt(args[0]);
            int numMappers = Integer.parseInt(args[1]);
            long numNodes = Long.parseLong(args[2]);
            String outputDir = args[3];
            int numReducers = Integer.parseInt(args[4]);
            Integer width = args.length < 6 ? null : Integer.valueOf(Integer.parseInt(args[5]));
            Integer wrapMuplitplier = args.length < 7 ? null : Integer.valueOf(Integer.parseInt(args[6]));
            long expectedNumNodes = 0L;
            if (numIterations < 0) {
                numIterations = Integer.MAX_VALUE;
            }
            for (int i = 0; i < numIterations; ++i) {
                LOG.info((Object)("Starting iteration = " + i));
                this.runGenerator(numMappers, numNodes, outputDir, width, wrapMuplitplier);
                this.runVerify(outputDir, numReducers, expectedNumNodes += (long)numMappers * numNodes);
            }
            return 0;
        }
    }

    static class Verify
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Verify.class);
        protected static final BytesWritable DEF = new BytesWritable(NO_KEY);
        protected Job job;

        Verify() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                System.out.println("Usage : " + Verify.class.getSimpleName() + " <output dir> <num reducers>");
                return 0;
            }
            String outputDir = args[0];
            int numReducers = Integer.parseInt(args[1]);
            return this.run(outputDir, numReducers);
        }

        public int run(String outputDir, int numReducers) throws Exception {
            return this.run(new Path(outputDir), numReducers);
        }

        public int run(Path outputDir, int numReducers) throws Exception {
            LOG.info((Object)("Running Verify with outputDir=" + outputDir + ", numReducers=" + numReducers));
            this.job = new Job(this.getConf());
            this.job.setJobName("Link Verifier");
            this.job.setNumReduceTasks(numReducers);
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            IntegrationTestBigLinkedList.setJobScannerConf(this.job);
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            scan.setCaching(10000);
            scan.setCacheBlocks(false);
            TableMapReduceUtil.initTableMapperJob((byte[])IntegrationTestBigLinkedList.getTableName(this.getConf()).getName(), (Scan)scan, VerifyMapper.class, BytesWritable.class, BytesWritable.class, (Job)this.job);
            TableMapReduceUtil.addDependencyJars((Configuration)this.job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            this.job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
            this.job.setReducerClass(VerifyReducer.class);
            this.job.setOutputFormatClass(TextOutputFormat.class);
            TextOutputFormat.setOutputPath((Job)this.job, (Path)outputDir);
            boolean success = this.job.waitForCompletion(true);
            return success ? 0 : 1;
        }

        public boolean verify(long expectedReferenced) throws Exception {
            if (this.job == null) {
                throw new IllegalStateException("You should call run() first");
            }
            Counters counters = this.job.getCounters();
            Counter referenced = counters.findCounter((Enum)Counts.REFERENCED);
            Counter unreferenced = counters.findCounter((Enum)Counts.UNREFERENCED);
            Counter undefined = counters.findCounter((Enum)Counts.UNDEFINED);
            Counter multiref = counters.findCounter((Enum)Counts.EXTRAREFERENCES);
            boolean success = true;
            if (expectedReferenced != referenced.getValue()) {
                LOG.error((Object)("Expected referenced count does not match with actual referenced count. expected referenced=" + expectedReferenced + " ,actual=" + referenced.getValue()));
                success = false;
            }
            if (unreferenced.getValue() > 0L) {
                boolean couldBeMultiRef = multiref.getValue() == unreferenced.getValue();
                LOG.error((Object)("Unreferenced nodes were not expected. Unreferenced count=" + unreferenced.getValue() + (couldBeMultiRef ? "; could be due to duplicate random numbers" : "")));
                success = false;
            }
            if (undefined.getValue() > 0L) {
                LOG.error((Object)("Found an undefined node. Undefined count=" + undefined.getValue()));
                success = false;
            }
            if (!success) {
                this.handleFailure(counters);
            }
            return success;
        }

        protected void handleFailure(Counters counters) throws IOException {
            HRegionLocation loc;
            byte[] key;
            String keyString;
            Configuration conf = this.job.getConfiguration();
            HConnection conn = HConnectionManager.getConnection((Configuration)conf);
            TableName tableName = IntegrationTestBigLinkedList.getTableName(conf);
            CounterGroup g = (CounterGroup)counters.getGroup("undef");
            Iterator it = g.iterator();
            while (it.hasNext()) {
                keyString = ((Counter)it.next()).getName();
                key = Bytes.toBytes((String)keyString);
                loc = conn.relocateRegion(tableName, key);
                LOG.error((Object)("undefined row " + keyString + ", " + loc));
            }
            g = (CounterGroup)counters.getGroup("unref");
            it = g.iterator();
            while (it.hasNext()) {
                keyString = ((Counter)it.next()).getName();
                key = Bytes.toBytes((String)keyString);
                loc = conn.relocateRegion(tableName, key);
                LOG.error((Object)("unreferred row " + keyString + ", " + loc));
            }
        }

        public static class VerifyReducer
        extends Reducer<BytesWritable, BytesWritable, Text, Text> {
            private ArrayList<byte[]> refs = new ArrayList();
            private AtomicInteger rows = new AtomicInteger(0);

            public void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
                int defCount = 0;
                this.refs.clear();
                for (BytesWritable type : values) {
                    if (type.getLength() == DEF.getLength()) {
                        ++defCount;
                        continue;
                    }
                    byte[] bytes = new byte[type.getLength()];
                    System.arraycopy(type.getBytes(), 0, bytes, 0, type.getLength());
                    this.refs.add(bytes);
                }
                StringBuilder refsSb = null;
                String keyString = null;
                if (defCount == 0 || this.refs.size() != 1) {
                    refsSb = new StringBuilder();
                    String comma = "";
                    for (byte[] ref : this.refs) {
                        refsSb.append(comma);
                        comma = ",";
                        refsSb.append(Bytes.toStringBinary((byte[])ref));
                    }
                    keyString = Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength());
                    LOG.error((Object)("Linked List error: Key = " + keyString + " References = " + refsSb.toString()));
                }
                if (defCount == 0 && this.refs.size() > 0) {
                    context.write((Object)new Text(keyString), (Object)new Text(refsSb.toString()));
                    context.getCounter((Enum)Counts.UNDEFINED).increment(1L);
                    if (this.rows.addAndGet(1) < 50) {
                        context.getCounter("undef", keyString).increment(1L);
                    }
                } else if (defCount > 0 && this.refs.size() == 0) {
                    context.write((Object)new Text(keyString), (Object)new Text("none"));
                    context.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                    if (this.rows.addAndGet(1) < 50) {
                        context.getCounter("unref", keyString).increment(1L);
                    }
                } else {
                    if (this.refs.size() > 1) {
                        if (refsSb != null) {
                            context.write((Object)new Text(keyString), (Object)new Text(refsSb.toString()));
                        }
                        context.getCounter((Enum)Counts.EXTRAREFERENCES).increment((long)(this.refs.size() - 1));
                    }
                    context.getCounter((Enum)Counts.REFERENCED).increment(1L);
                }
            }
        }

        public static enum Counts {
            UNREFERENCED,
            UNDEFINED,
            REFERENCED,
            CORRUPT,
            EXTRAREFERENCES;

        }

        public static class VerifyMapper
        extends TableMapper<BytesWritable, BytesWritable> {
            private BytesWritable row = new BytesWritable();
            private BytesWritable ref = new BytesWritable();

            protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
                byte[] rowKey = key.get();
                this.row.set(rowKey, 0, rowKey.length);
                context.write((Object)this.row, (Object)DEF);
                byte[] prev = value.getValue(FAMILY_NAME, COLUMN_PREV);
                if (prev != null && prev.length > 0) {
                    this.ref.set(prev, 0, prev.length);
                    context.write((Object)this.ref, (Object)this.row);
                } else {
                    LOG.warn((Object)String.format("Prev is not set for: %s", Bytes.toStringBinary((byte[])rowKey)));
                }
            }
        }
    }

    static class Generator
    extends Configured
    implements Tool {
        private static final Log LOG = LogFactory.getLog(Generator.class);

        Generator() {
        }

        public int run(String[] args) throws Exception {
            if (args.length < 3) {
                System.out.println("Usage : " + Generator.class.getSimpleName() + " <num mappers> <num nodes per map> <tmp output dir> [<width> <wrap multiplier>]");
                System.out.println("   where <num nodes per map> should be a multiple of  width*wrap multiplier, 25M by default");
                return 0;
            }
            int numMappers = Integer.parseInt(args[0]);
            long numNodes = Long.parseLong(args[1]);
            Path tmpOutput = new Path(args[2]);
            Integer width = args.length < 4 ? null : Integer.valueOf(Integer.parseInt(args[3]));
            Integer wrapMuplitplier = args.length < 5 ? null : Integer.valueOf(Integer.parseInt(args[4]));
            return this.run(numMappers, numNodes, tmpOutput, width, wrapMuplitplier);
        }

        protected void createSchema() throws IOException {
            Configuration conf = this.getConf();
            HBaseAdmin admin = new HBaseAdmin(conf);
            TableName tableName = IntegrationTestBigLinkedList.getTableName(conf);
            try {
                if (!admin.tableExists(tableName)) {
                    HTableDescriptor htd = new HTableDescriptor(IntegrationTestBigLinkedList.getTableName(this.getConf()));
                    htd.addFamily(new HColumnDescriptor(FAMILY_NAME));
                    int numberOfServers = admin.getClusterStatus().getServers().size();
                    if (numberOfServers == 0) {
                        throw new IllegalStateException("No live regionservers");
                    }
                    int regionsPerServer = conf.getInt("hbase.test.regions-per-server", 5);
                    int totalNumberOfRegions = numberOfServers * regionsPerServer;
                    LOG.info((Object)("Number of live regionservers: " + numberOfServers + ", " + "pre-splitting table into " + totalNumberOfRegions + " regions " + "(default regions per server: " + regionsPerServer + ")"));
                    byte[][] splits = new RegionSplitter.UniformSplit().split(totalNumberOfRegions);
                    admin.createTable(htd, splits);
                }
            }
            catch (MasterNotRunningException e) {
                LOG.error((Object)"Master not running", (Throwable)e);
                throw new IOException(e);
            }
            finally {
                admin.close();
            }
        }

        public int runRandomInputGenerator(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMuplitplier) throws Exception {
            LOG.info((Object)("Running RandomInputGenerator with numMappers=" + numMappers + ", numNodes=" + numNodes));
            Job job = new Job(this.getConf());
            job.setJobName("Random Input Generator");
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(GeneratorInputFormat.class);
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(NullWritable.class);
            IntegrationTestBigLinkedList.setJobConf(job, numMappers, numNodes, width, wrapMuplitplier);
            job.setMapperClass(Mapper.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)tmpOutput);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            boolean success = this.jobCompletion(job);
            return success ? 0 : 1;
        }

        public int runGenerator(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMuplitplier) throws Exception {
            LOG.info((Object)("Running Generator with numMappers=" + numMappers + ", numNodes=" + numNodes));
            this.createSchema();
            Job job = new Job(this.getConf());
            job.setJobName("Link Generator");
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{tmpOutput});
            job.setInputFormatClass(OneFilePerMapperSFIF.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(NullWritable.class);
            IntegrationTestBigLinkedList.setJobConf(job, numMappers, numNodes, width, wrapMuplitplier);
            this.setMapperForGenerator(job);
            job.setOutputFormatClass(NullOutputFormat.class);
            job.getConfiguration().setBoolean("mapred.map.tasks.speculative.execution", false);
            TableMapReduceUtil.addDependencyJars((Job)job);
            TableMapReduceUtil.addDependencyJars((Configuration)job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            TableMapReduceUtil.initCredentials((Job)job);
            boolean success = this.jobCompletion(job);
            return success ? 0 : 1;
        }

        protected boolean jobCompletion(Job job) throws IOException, InterruptedException, ClassNotFoundException {
            boolean success = job.waitForCompletion(true);
            return success;
        }

        protected void setMapperForGenerator(Job job) {
            job.setMapperClass(GeneratorMapper.class);
        }

        public int run(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMuplitplier) throws Exception {
            int ret = this.runRandomInputGenerator(numMappers, numNodes, tmpOutput, width, wrapMuplitplier);
            if (ret > 0) {
                return ret;
            }
            return this.runGenerator(numMappers, numNodes, tmpOutput, width, wrapMuplitplier);
        }

        static class GeneratorMapper
        extends Mapper<BytesWritable, NullWritable, NullWritable, NullWritable> {
            byte[][] first = null;
            byte[][] prev = null;
            byte[][] current = null;
            byte[] id;
            long count = 0L;
            int i;
            HTable table;
            long numNodes;
            long wrap;
            int width;

            GeneratorMapper() {
            }

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                this.id = Bytes.toBytes((String)("Job: " + context.getJobID() + " Task: " + context.getTaskAttemptID()));
                Configuration conf = context.getConfiguration();
                this.instantiateHTable(conf);
                this.width = context.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_WIDTH_KEY, 1000000);
                this.current = new byte[this.width][];
                int wrapMultiplier = context.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_WRAP_KEY, 25);
                this.wrap = (long)wrapMultiplier * (long)this.width;
                this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, 25000000L);
                if (this.numNodes < this.wrap) {
                    this.wrap = this.numNodes;
                }
            }

            protected void instantiateHTable(Configuration conf) throws IOException {
                this.table = new HTable(conf, IntegrationTestBigLinkedList.getTableName(conf));
                this.table.setAutoFlush(false, true);
                this.table.setWriteBufferSize(0x400000L);
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                this.table.close();
            }

            protected void map(BytesWritable key, NullWritable value, Mapper.Context output) throws IOException {
                this.current[this.i] = new byte[key.getLength()];
                System.arraycopy(key.getBytes(), 0, this.current[this.i], 0, key.getLength());
                if (++this.i == this.current.length) {
                    this.persist(output, this.count, this.prev, this.current, this.id);
                    this.i = 0;
                    if (this.first == null) {
                        this.first = this.current;
                    }
                    this.prev = this.current;
                    this.current = new byte[this.width][];
                    this.count += (long)this.current.length;
                    output.setStatus("Count " + this.count);
                    if (this.count % this.wrap == 0L) {
                        GeneratorMapper.circularLeftShift(this.first);
                        this.persist(output, -1L, this.prev, this.first, null);
                        this.first = null;
                        this.prev = null;
                    }
                }
            }

            private static <T> void circularLeftShift(T[] first) {
                T ez = first[0];
                for (int i = 0; i < first.length - 1; ++i) {
                    first[i] = first[i + 1];
                }
                first[first.length - 1] = ez;
            }

            protected void persist(Mapper.Context output, long count, byte[][] prev, byte[][] current, byte[] id) throws IOException {
                for (int i = 0; i < current.length; ++i) {
                    Put put = new Put(current[i]);
                    put.add(FAMILY_NAME, COLUMN_PREV, prev == null ? NO_KEY : prev[i]);
                    if (count >= 0L) {
                        put.add(FAMILY_NAME, COLUMN_COUNT, Bytes.toBytes((long)(count + (long)i)));
                    }
                    if (id != null) {
                        put.add(FAMILY_NAME, COLUMN_CLIENT, id);
                    }
                    this.table.put(put);
                    if (i % 1000 != 0) continue;
                    output.progress();
                }
                this.table.flushCommits();
            }
        }

        static class OneFilePerMapperSFIF<K, V>
        extends SequenceFileInputFormat<K, V> {
            OneFilePerMapperSFIF() {
            }

            protected boolean isSplitable(JobContext context, Path filename) {
                return false;
            }
        }

        static class GeneratorInputFormat
        extends InputFormat<BytesWritable, NullWritable> {
            GeneratorInputFormat() {
            }

            public RecordReader<BytesWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                GeneratorRecordReader rr = new GeneratorRecordReader();
                rr.initialize(split, context);
                return rr;
            }

            public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
                int numMappers = job.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, 1);
                ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numMappers);
                for (int i = 0; i < numMappers; ++i) {
                    splits.add(new GeneratorInputSplit());
                }
                return splits;
            }

            static class GeneratorRecordReader
            extends RecordReader<BytesWritable, NullWritable> {
                private long count;
                private long numNodes;
                private Random rand;

                GeneratorRecordReader() {
                }

                public void close() throws IOException {
                }

                public BytesWritable getCurrentKey() throws IOException, InterruptedException {
                    byte[] bytes = new byte[16];
                    this.rand.nextBytes(bytes);
                    return new BytesWritable(bytes);
                }

                public NullWritable getCurrentValue() throws IOException, InterruptedException {
                    return NullWritable.get();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return (float)((double)this.count / (double)this.numNodes);
                }

                public void initialize(InputSplit arg0, TaskAttemptContext context) throws IOException, InterruptedException {
                    this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, 25000000L);
                    this.rand = new Random();
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return this.count++ < this.numNodes;
                }
            }

            static class GeneratorInputSplit
            extends InputSplit
            implements Writable {
                GeneratorInputSplit() {
                }

                public long getLength() throws IOException, InterruptedException {
                    return 1L;
                }

                public String[] getLocations() throws IOException, InterruptedException {
                    return new String[0];
                }

                public void readFields(DataInput arg0) throws IOException {
                }

                public void write(DataOutput arg0) throws IOException {
                }
            }
        }
    }

    static class CINode {
        byte[] key;
        byte[] prev;
        String client;
        long count;

        CINode() {
        }
    }
}

