/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.util.LoadTestDataGeneratorWithTags;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithTags
extends IntegrationTestIngest {
    private static final char COLON = ':';
    private int minTagsPerKey = 1;
    private int maxTagsPerKey = 10;
    private int minTagLength = 16;
    private int maxTagLength = 512;

    @Override
    public void setUpCluster() throws Exception {
        this.getTestingUtil(this.conf).getConfiguration().setInt("hfile.format.version", 3);
        super.setUpCluster();
    }

    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        String[] args = super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys);
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(args));
        tmp.add("-generator");
        StringBuilder sb = new StringBuilder(LoadTestDataGeneratorWithTags.class.getName());
        sb.append(':');
        sb.append(this.minTagsPerKey);
        sb.append(':');
        sb.append(this.maxTagsPerKey);
        sb.append(':');
        sb.append(this.minTagLength);
        sb.append(':');
        sb.append(this.maxTagLength);
        tmp.add(sb.toString());
        return tmp.toArray(new String[tmp.size()]);
    }
}

