/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class DistributedHBaseCluster
extends HBaseCluster {
    private HBaseAdmin admin;
    private ClusterManager clusterManager;

    public DistributedHBaseCluster(Configuration conf, ClusterManager clusterManager) throws IOException {
        super(conf);
        this.clusterManager = clusterManager;
        this.admin = new HBaseAdmin(conf);
        this.initialClusterStatus = this.getClusterStatus();
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.admin.getClusterStatus();
    }

    public ClusterStatus getInitialClusterStatus() throws IOException {
        return this.initialClusterStatus;
    }

    public void close() throws IOException {
        if (this.admin != null) {
            this.admin.close();
        }
    }

    public AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName serverName) throws IOException {
        return this.admin.getConnection().getAdmin(serverName);
    }

    public ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName serverName) throws IOException {
        return this.admin.getConnection().getClient(serverName);
    }

    public void startRegionServer(String hostname) throws IOException {
        LOG.info((Object)("Starting RS on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname);
    }

    public void killRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting RS: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname());
    }

    public void stopRegionServer(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping RS: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname());
    }

    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName, timeout);
    }

    private void waitForServiceToStop(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info((Object)("Waiting service:" + (Object)((Object)service) + " to stop: " + serverName.getServerName()));
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.clusterManager.isRunning(service, serverName.getHostname())) {
                return;
            }
            Threads.sleep((long)1000L);
        }
        throw new IOException("did timeout waiting for service to stop:" + serverName);
    }

    public MasterProtos.MasterService.BlockingInterface getMaster() throws IOException {
        HConnection conn = HConnectionManager.getConnection((Configuration)this.conf);
        return conn.getMaster();
    }

    public void startMaster(String hostname) throws IOException {
        LOG.info((Object)("Starting Master on: " + hostname));
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_MASTER, hostname);
    }

    public void killMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Aborting Master: " + serverName.getServerName()));
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname());
    }

    public void stopMaster(ServerName serverName) throws IOException {
        LOG.info((Object)("Stopping Master: " + serverName.getServerName()));
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname());
    }

    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_MASTER, serverName, timeout);
    }

    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                this.getMaster();
                return true;
            }
            catch (MasterNotRunningException m) {
                LOG.warn((Object)("Master not started yet " + (Object)((Object)m)));
            }
            catch (ZooKeeperConnectionException e) {
                LOG.warn((Object)("Failed to connect to ZK " + (Object)((Object)e)));
            }
            Threads.sleep((long)1000L);
        }
        return false;
    }

    public ServerName getServerHoldingRegion(byte[] regionName) throws IOException {
        HConnection connection = this.admin.getConnection();
        HRegionLocation regionLoc = connection.locateRegion(regionName);
        if (regionLoc == null) {
            LOG.warn((Object)("Cannot find region server holding region " + Bytes.toString((byte[])regionName) + " for table " + HRegionInfo.getTableName((byte[])regionName) + ", start key [" + Bytes.toString((byte[])HRegionInfo.getStartKey((byte[])regionName)) + "]"));
            return null;
        }
        AdminProtos.AdminService.BlockingInterface client = connection.getAdmin(regionLoc.getServerName());
        AdminProtos.ServerInfo info = ProtobufUtil.getServerInfo((AdminProtos.AdminService.BlockingInterface)client);
        return ProtobufUtil.toServerName((HBaseProtos.ServerName)info.getServerName());
    }

    public void waitUntilShutDown() {
        throw new RuntimeException("Not implemented yet");
    }

    public void shutdown() throws IOException {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isDistributedCluster() {
        return true;
    }

    public boolean restoreClusterStatus(ClusterStatus initial) throws IOException {
        ClusterStatus current = this.getClusterStatus();
        LOG.info((Object)"Restoring cluster - started");
        boolean success = true;
        success = this.restoreMasters(initial, current) & success;
        success = this.restoreRegionServers(initial, current) & success;
        success = this.restoreAdmin() & success;
        LOG.info((Object)"Restoring cluster - done");
        return success;
    }

    protected boolean restoreMasters(ClusterStatus initial, ClusterStatus current) {
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        if (!ServerName.isSameHostnameAndPort((ServerName)initial.getMaster(), (ServerName)current.getMaster())) {
            LOG.info((Object)("Restoring cluster - Initial active master : " + initial.getMaster().getHostname() + " has changed to : " + current.getMaster().getHostname()));
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, initial.getMaster().getHostname())) {
                    LOG.info((Object)("Restoring cluster - starting initial active master at:" + initial.getMaster().getHostname()));
                    this.startMaster(initial.getMaster().getHostname());
                }
                for (ServerName currentBackup : current.getBackupMasters()) {
                    if (ServerName.isSameHostnameAndPort((ServerName)currentBackup, (ServerName)initial.getMaster())) continue;
                    LOG.info((Object)("Restoring cluster - stopping backup master: " + currentBackup));
                    this.stopMaster(currentBackup);
                }
                LOG.info((Object)("Restoring cluster - stopping active master: " + current.getMaster()));
                this.stopMaster(current.getMaster());
                this.waitForActiveAndReadyMaster();
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
            for (ServerName backup : initial.getBackupMasters()) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, backup.getHostname())) continue;
                    LOG.info((Object)("Restoring cluster - starting initial backup master: " + backup.getHostname()));
                    this.startMaster(backup.getHostname());
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        } else {
            HashMap<String, ServerName> initialBackups = new HashMap<String, ServerName>();
            HashMap<String, ServerName> currentBackups = new HashMap<String, ServerName>();
            for (ServerName server : initial.getBackupMasters()) {
                initialBackups.put(server.getHostname(), server);
            }
            for (ServerName server : current.getBackupMasters()) {
                currentBackups.put(server.getHostname(), server);
            }
            for (String hostname : Sets.difference(initialBackups.keySet(), currentBackups.keySet())) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, hostname)) continue;
                    LOG.info((Object)("Restoring cluster - starting initial backup master: " + hostname));
                    this.startMaster(hostname);
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
            for (String hostname : Sets.difference(currentBackups.keySet(), initialBackups.keySet())) {
                try {
                    if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, hostname)) continue;
                    LOG.info((Object)("Restoring cluster - stopping backup master: " + hostname));
                    this.stopMaster((ServerName)currentBackups.get(hostname));
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn((Object)("Restoring cluster - restoring region servers reported " + deferred.size() + " errors:"));
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(deferred.get(i));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreRegionServers(ClusterStatus initial, ClusterStatus current) {
        HashMap<String, ServerName> initialServers = new HashMap<String, ServerName>();
        HashMap<String, ServerName> currentServers = new HashMap<String, ServerName>();
        for (ServerName server : initial.getServers()) {
            initialServers.put(server.getHostname(), server);
        }
        for (ServerName server : current.getServers()) {
            currentServers.put(server.getHostname(), server);
        }
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        for (String hostname : Sets.difference(initialServers.keySet(), currentServers.keySet())) {
            try {
                if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname)) continue;
                LOG.info((Object)("Restoring cluster - starting initial region server: " + hostname));
                this.startRegionServer(hostname);
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        for (String hostname : Sets.difference(currentServers.keySet(), initialServers.keySet())) {
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname)) continue;
                LOG.info((Object)("Restoring cluster - stopping initial region server: " + hostname));
                this.stopRegionServer((ServerName)currentServers.get(hostname));
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn((Object)("Restoring cluster - restoring region servers reported " + deferred.size() + " errors:"));
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(deferred.get(i));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreAdmin() throws IOException {
        try {
            this.admin.close();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"While closing the old connection", (Throwable)ioe);
        }
        this.admin = new HBaseAdmin(this.conf);
        LOG.info((Object)"Added new HBaseAdmin");
        return true;
    }
}

