/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;

public class ChangeEncodingAction
extends Action {
    private final byte[] tableName;
    private final String tableNameString;
    private HBaseAdmin admin;
    private Random random;

    public ChangeEncodingAction(String tableName) {
        this.tableNameString = tableName;
        this.tableName = Bytes.toBytes((String)tableName);
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getHBaseAdmin();
    }

    @Override
    public void perform() throws Exception {
        HTableDescriptor tableDescriptor = this.admin.getTableDescriptor(this.tableName);
        HColumnDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors == null || columnDescriptors.length == 0) {
            return;
        }
        LOG.debug((Object)("Performing action: Changing encodings on " + this.tableNameString));
        int[] possibleIds = new int[]{0, 2, 3, 4};
        for (HColumnDescriptor descriptor : columnDescriptors) {
            short id = (short)possibleIds[this.random.nextInt(possibleIds.length)];
            descriptor.setDataBlockEncoding(DataBlockEncoding.getEncodingById((short)id));
        }
        this.admin.modifyTable(this.tableName, tableDescriptor);
    }
}

