/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.IntegrationTests;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV3;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV3;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Before;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithEncryption
extends IntegrationTestIngest {
    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        if (!this.util.isDistributedCluster()) {
            conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
            conf.set("hbase.crypto.master.key.name", "hbase");
            conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, HLog.Reader.class);
            conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, HLog.Writer.class);
            conf.setBoolean("hbase.regionserver.wal.encryption", true);
        }
        super.setUpCluster();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        final HBaseAdmin admin = this.util.getHBaseAdmin();
        HTableDescriptor tableDescriptor = new HTableDescriptor(admin.getTableDescriptor(Bytes.toBytes((String)this.getTablename())));
        for (HColumnDescriptor columnDescriptor : tableDescriptor.getColumnFamilies()) {
            columnDescriptor.setEncryptionType("AES");
            LOG.info((Object)("Updating CF schema for " + this.getTablename() + "." + columnDescriptor.getNameAsString()));
            admin.disableTable(this.getTablename());
            admin.modifyColumn(this.getTablename(), columnDescriptor);
            admin.enableTable(this.getTablename());
            this.util.waitFor(30000L, 1000L, true, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

                public boolean evaluate() throws IOException {
                    return admin.isTableAvailable(IntegrationTestIngestWithEncryption.this.getTablename());
                }
            });
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngestWithEncryption(), (String[])args);
        System.exit(ret);
    }

    static {
        Logger.getLogger(HFileReaderV3.class).setLevel(Level.TRACE);
        Logger.getLogger(HFileWriterV3.class).setLevel(Level.TRACE);
        Logger.getLogger(SecureProtobufLogReader.class).setLevel(Level.TRACE);
        Logger.getLogger(SecureProtobufLogWriter.class).setLevel(Level.TRACE);
    }
}

