/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LargeTests;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.IndexBuilder;
import org.apache.hadoop.hbase.mapreduce.SampleUploader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestMapReduceExamples {
    private static HBaseTestingUtility util = new HBaseTestingUtility();

    @Test
    public void testSampleUploader() throws Exception {
        Configuration configuration = new Configuration();
        SampleUploader.Uploader uploader = new SampleUploader.Uploader();
        Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                Put put = (Put)invocation.getArguments()[1];
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])put.getRow()));
                return null;
            }
        }).when((Object)ctx)).write(Mockito.any(ImmutableBytesWritable.class), Mockito.any(Put.class));
        uploader.map(null, new Text("row,family,qualifier,value"), ctx);
        Path dir = util.getDataTestDirOnTestFS("testSampleUploader");
        String[] args = new String[]{dir.toString(), "simpleTable"};
        Job job = SampleUploader.configureJob((Configuration)configuration, (String[])args);
        Assert.assertEquals(SequenceFileInputFormat.class, (Object)job.getInputFormatClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainSampleUploader() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                SampleUploader.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("Wrong number of arguments:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: SampleUploader <input> <tablename>"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }

    @Test
    public void testIndexBuilder() throws Exception {
        Configuration configuration = new Configuration();
        String[] args = new String[]{"tableName", "columnFamily", "column1", "column2"};
        IndexBuilder.configureJob((Configuration)configuration, (String[])args);
        Assert.assertEquals((Object)"tableName", (Object)configuration.get("index.tablename"));
        Assert.assertEquals((Object)"tableName", (Object)configuration.get("hbase.mapreduce.inputtable"));
        Assert.assertEquals((Object)"column1,column2", (Object)configuration.get("index.fields"));
        IndexBuilder.Map map = new IndexBuilder.Map();
        ImmutableBytesWritable rowKey = new ImmutableBytesWritable(Bytes.toBytes((String)"test"));
        Mapper.Context ctx = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                Put put = (Put)invocation.getArguments()[1];
                Assert.assertEquals((Object)"tableName-column1", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"test", (Object)Bytes.toString((byte[])put.getRow()));
                return null;
            }
        }).when((Object)ctx)).write(Mockito.any(ImmutableBytesWritable.class), Mockito.any(Put.class));
        Result result = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)result.getValue(Bytes.toBytes((String)"columnFamily"), Bytes.toBytes((String)"column1"))).thenReturn((Object)Bytes.toBytes((String)"test"));
        map.setup(ctx);
        map.map(rowKey, result, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainIndexBuilder() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                IndexBuilder.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("arguments supplied, required: 3"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: IndexBuilder <TABLE_NAME> <COLUMN_FAMILY> <ATTR> [<ATTR> ...]"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

