/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Tag {
    public static final int TYPE_LENGTH_SIZE = 1;
    public static final int TAG_LENGTH_SIZE = 2;
    public static final int INFRASTRUCTURE_SIZE = 3;
    private static final int MAX_TAG_LENGTH = 65533;
    private final byte type;
    private final byte[] bytes;
    private int offset = 0;
    private int length = 0;

    public Tag(byte tagType, String tag) {
        this(tagType, Bytes.toBytes(tag));
    }

    public Tag(byte tagType, byte[] tag) {
        int tagLength = tag.length + 1;
        if (tagLength > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.length = 2 + tagLength;
        this.bytes = new byte[this.length];
        int pos = Bytes.putAsShort(this.bytes, 0, tagLength);
        pos = Bytes.putByte(this.bytes, pos, tagType);
        Bytes.putBytes(this.bytes, pos, tag, 0, tag.length);
        this.type = tagType;
    }

    public Tag(byte[] bytes, int offset) {
        this(bytes, offset, Tag.getLength(bytes, offset));
    }

    private static int getLength(byte[] bytes, int offset) {
        return 2 + Bytes.readAsInt(bytes, offset, 2);
    }

    @Deprecated
    public Tag(byte[] bytes, int offset, short length) {
        this(bytes, offset, (int)length);
    }

    public Tag(byte[] bytes, int offset, int length) {
        if (length > 65533) {
            throw new IllegalArgumentException("Invalid tag data being passed. Its length can not exceed 65533");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.type = bytes[offset + 2];
    }

    public byte[] getBuffer() {
        return this.bytes;
    }

    public byte getType() {
        return this.type;
    }

    public int getTagLength() {
        return this.length - 3;
    }

    public int getTagOffset() {
        return this.offset + 3;
    }

    public byte[] getValue() {
        int tagLength = this.getTagLength();
        byte[] tag = new byte[tagLength];
        Bytes.putBytes(tag, 0, this.bytes, this.getTagOffset(), tagLength);
        return tag;
    }

    public static List<Tag> asList(byte[] b, int offset, int length) {
        int tagLen;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            tags.add(new Tag(b, pos, tagLen + 2));
        }
        return tags;
    }

    public static Tag getTag(byte[] b, int offset, int length, byte type) {
        int tagLen;
        for (int pos = offset; pos < offset + length; pos += 2 + tagLen) {
            tagLen = Bytes.readAsInt(b, pos, 2);
            if (b[pos + 2] != type) continue;
            return new Tag(b, pos, tagLen + 2);
        }
        return null;
    }

    int getLength() {
        return this.length;
    }

    int getOffset() {
        return this.offset;
    }
}

