/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSmallScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestClientSmallScanner {
    Scan scan;
    ExecutorService pool;
    Configuration conf;
    ClusterConnection clusterConn;
    RpcRetryingCallerFactory rpcFactory;
    RpcControllerFactory controllerFactory;
    RpcRetryingCaller<Result[]> caller;

    @Before
    public void setup() throws IOException {
        this.clusterConn = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        this.rpcFactory = (RpcRetryingCallerFactory)Mockito.mock(RpcRetryingCallerFactory.class);
        this.controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        this.pool = Executors.newSingleThreadExecutor();
        this.scan = new Scan();
        this.conf = new Configuration();
        Mockito.when((Object)this.clusterConn.getConfiguration()).thenReturn((Object)this.conf);
        this.caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn(this.caller);
    }

    @After
    public void teardown() {
        if (null != this.pool) {
            this.pool.shutdownNow();
        }
    }

    private Answer<Boolean> createTrueThenFalseAnswer() {
        return new Answer<Boolean>(){
            boolean first = true;

            public Boolean answer(InvocationOnMock invocation) {
                if (this.first) {
                    this.first = false;
                    return true;
                }
                return false;
            }
        };
    }

    private ClientSmallScanner.SmallScannerCallableFactory getFactory(final ScannerCallableWithReplicas callableWithReplicas) {
        return new ClientSmallScanner.SmallScannerCallableFactory(){

            public ScannerCallableWithReplicas getCallable(ClusterConnection connection, TableName table, Scan scan, ScanMetrics scanMetrics, byte[] localStartKey, int cacheNum, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout, int retries, int scannerTimeout, Configuration conf, RpcRetryingCaller<Result[]> caller) {
                return callableWithReplicas;
            }
        };
    }

    @Test
    public void testContextPresent() throws Exception {
        final KeyValue kv1 = new KeyValue("row1".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv3 = new KeyValue("row3".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        ScannerCallableWithReplicas callableWithReplicas = (ScannerCallableWithReplicas)Mockito.mock(ScannerCallableWithReplicas.class);
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory(callableWithReplicas);
        try (ClientSmallScanner css = new ClientSmallScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            css.setScannerCallableFactory(factory);
            Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)callableWithReplicas, css.getScannerTimeout())).thenAnswer((Answer)new Answer<Result[]>(){
                int count = 0;

                public Result[] answer(InvocationOnMock invocation) {
                    Result[] results = 0 == this.count ? new Result[]{Result.create((Cell[])new Cell[]{kv1}), Result.create((Cell[])new Cell[]{kv2})} : (1 == this.count ? new Result[]{Result.create((Cell[])new Cell[]{kv3})} : new Result[]{});
                    ++this.count;
                    return results;
                }
            });
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)true);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenAnswer(this.createTrueThenFalseAnswer());
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            css.loadCache();
            LinkedList results = css.cache;
            Assert.assertEquals((long)3L, (long)results.size());
            for (int i = 1; i <= 3; ++i) {
                Result result = (Result)results.get(i - 1);
                byte[] row = result.getRow();
                Assert.assertEquals((Object)("row" + i), (Object)new String(row, StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)result.getMap().size());
            }
            Assert.assertTrue((boolean)css.closed);
        }
    }

    @Test
    public void testNoContextFewerRecords() throws Exception {
        final KeyValue kv1 = new KeyValue("row1".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv3 = new KeyValue("row3".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        ScannerCallableWithReplicas callableWithReplicas = (ScannerCallableWithReplicas)Mockito.mock(ScannerCallableWithReplicas.class);
        this.scan.setCaching(2);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory(callableWithReplicas);
        try (ClientSmallScanner css = new ClientSmallScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            css.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithoutRetries((RetryingCallable)callableWithReplicas, css.getScannerTimeout())).thenAnswer((Answer)new Answer<Result[]>(){
                int count = 0;

                public Result[] answer(InvocationOnMock invocation) {
                    Result[] results;
                    if (0 == this.count) {
                        results = new Result[]{Result.create((Cell[])new Cell[]{kv1}), Result.create((Cell[])new Cell[]{kv2})};
                    } else if (1 == this.count) {
                        results = new Result[]{Result.create((Cell[])new Cell[]{kv3})};
                    } else {
                        throw new RuntimeException("Should not fetch a third batch from the server");
                    }
                    ++this.count;
                    return results;
                }
            });
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)false);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenThrow(new Throwable[]{new RuntimeException("Should not be called")});
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            css.loadCache();
            LinkedList results = css.cache;
            Assert.assertEquals((long)2L, (long)results.size());
            for (int i = 1; i <= 2; ++i) {
                Result result = (Result)results.get(i - 1);
                byte[] row = result.getRow();
                Assert.assertEquals((Object)("row" + i), (Object)new String(row, StandardCharsets.UTF_8));
                Assert.assertEquals((long)1L, (long)result.getMap().size());
            }
            results.clear();
            css.loadCache();
            Assert.assertEquals((long)1L, (long)results.size());
            Result result = (Result)results.get(0);
            Assert.assertEquals((Object)"row3", (Object)new String(result.getRow(), StandardCharsets.UTF_8));
            Assert.assertEquals((long)1L, (long)result.getMap().size());
            Assert.assertTrue((boolean)css.closed);
        }
    }

    @Test
    public void testNoContextNoRecords() throws Exception {
        ScannerCallableWithReplicas callableWithReplicas = (ScannerCallableWithReplicas)Mockito.mock(ScannerCallableWithReplicas.class);
        this.scan.setCaching(2);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory(callableWithReplicas);
        try (ClientSmallScanner css = new ClientSmallScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            css.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithoutRetries((RetryingCallable)callableWithReplicas, css.getScannerTimeout())).thenReturn((Object)new Result[0]);
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)false);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenThrow(new Throwable[]{new RuntimeException("Should not be called")});
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            css.loadCache();
            Assert.assertEquals((long)0L, (long)css.cache.size());
            Assert.assertTrue((boolean)css.closed);
        }
    }

    @Test
    public void testContextNoRecords() throws Exception {
        ScannerCallableWithReplicas callableWithReplicas = (ScannerCallableWithReplicas)Mockito.mock(ScannerCallableWithReplicas.class);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory(callableWithReplicas);
        try (ClientSmallScanner css = new ClientSmallScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            css.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithoutRetries((RetryingCallable)callableWithReplicas, css.getScannerTimeout())).thenReturn((Object)new Result[0]);
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)true);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenReturn((Object)false);
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            css.loadCache();
            Assert.assertEquals((long)0L, (long)css.cache.size());
            Assert.assertTrue((boolean)css.closed);
        }
    }
}

