/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.SyncFailedException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.FastFailInterceptorContext;
import org.apache.hadoop.hbase.client.NoOpRetryableCallerInterceptor;
import org.apache.hadoop.hbase.client.NoOpRetryingInterceptorContext;
import org.apache.hadoop.hbase.client.PreemptiveFastFailInterceptor;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFastFailWithoutTestUtil {
    private static final Log LOG = LogFactory.getLog(TestFastFailWithoutTestUtil.class);
    ExecutorService executor = Executors.newCachedThreadPool();
    final int PAUSE_TIME = 10;
    final int RETRIES = 3;
    final int CLEANUP_TIMEOUT = 10000;
    final long FAST_FAIL_THRESHOLD = 10L;
    final CountDownLatch[] latches = new CountDownLatch[4];
    final CountDownLatch[] latches2 = new CountDownLatch[4];
    final AtomicInteger done = new AtomicInteger(0);
    final AtomicInteger priviRetryCounter = new AtomicInteger();
    final AtomicInteger nonPriviRetryCounter = new AtomicInteger();
    final ServerName serverName = TestFastFailWithoutTestUtil.getSomeServerName();
    public final ThreadLocal<AtomicBoolean> isPriviThreadLocal = new ThreadLocal<AtomicBoolean>(){

        @Override
        public AtomicBoolean initialValue() {
            return new AtomicBoolean(true);
        }
    };
    final Exception exception = new ConnectionClosingException("The current connection is closed");

    @Test
    public void testInterceptorFactoryMethods() {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        RetryingCallerInterceptorFactory interceptorFactory = new RetryingCallerInterceptorFactory(conf);
        RetryingCallerInterceptor interceptorBeforeCast = interceptorFactory.build();
        Assert.assertTrue((String)"We should be getting a PreemptiveFastFailInterceptor", (boolean)(interceptorBeforeCast instanceof PreemptiveFastFailInterceptor));
        PreemptiveFastFailInterceptor interceptor = (PreemptiveFastFailInterceptor)interceptorBeforeCast;
        RetryingCallerInterceptorContext contextBeforeCast = interceptor.createEmptyContext();
        Assert.assertTrue((String)"We should be getting a FastFailInterceptorContext since we are interacting with the PreemptiveFastFailInterceptor", (boolean)(contextBeforeCast instanceof FastFailInterceptorContext));
        FastFailInterceptorContext context = (FastFailInterceptorContext)contextBeforeCast;
        Assert.assertTrue((context != null ? 1 : 0) != 0);
        conf = HBaseConfiguration.create();
        interceptorFactory = new RetryingCallerInterceptorFactory(conf);
        interceptorBeforeCast = interceptorFactory.build();
        Assert.assertTrue((String)"We should be getting a NoOpRetryableCallerInterceptor since we disabled PFFE", (boolean)(interceptorBeforeCast instanceof NoOpRetryableCallerInterceptor));
        contextBeforeCast = interceptorBeforeCast.createEmptyContext();
        Assert.assertTrue((String)"We should be getting a NoOpRetryingInterceptorContext from NoOpRetryableCallerInterceptor", (boolean)(contextBeforeCast instanceof NoOpRetryingInterceptorContext));
        Assert.assertTrue((context != null ? 1 : 0) != 0);
    }

    @Test
    public void testInterceptorContextClear() {
        PreemptiveFastFailInterceptor interceptor = TestFastFailWithoutTestUtil.createPreemptiveInterceptor();
        FastFailInterceptorContext context = (FastFailInterceptorContext)interceptor.createEmptyContext();
        context.clear();
        Assert.assertFalse((boolean)context.getCouldNotCommunicateWithServer().booleanValue());
        Assert.assertEquals((Object)context.didTry(), (Object)false);
        Assert.assertEquals((Object)context.getFailureInfo(), null);
        Assert.assertEquals((Object)context.getServer(), null);
        Assert.assertEquals((long)context.getTries(), (long)0L);
    }

    @Test
    public void testInterceptorContextPrepare() throws IOException {
        PreemptiveFastFailInterceptor interceptor = TestFastFailWithoutTestUtil.createPreemptiveInterceptor();
        FastFailInterceptorContext context = (FastFailInterceptorContext)interceptor.createEmptyContext();
        RegionServerCallable<Boolean> callable = new RegionServerCallable<Boolean>(null, null, null){

            public Boolean call(int callTimeout) throws Exception {
                return true;
            }

            protected HRegionLocation getLocation() {
                return new HRegionLocation(null, ServerName.valueOf((String)"localhost", (int)1234, (long)987654321L));
            }
        };
        context.prepare((RetryingCallable)callable);
        ServerName server = TestFastFailWithoutTestUtil.getSomeServerName();
        Assert.assertEquals((Object)context.getServer(), (Object)server);
        context.clear();
        context.prepare((RetryingCallable)callable, 2);
        Assert.assertEquals((Object)context.getServer(), (Object)server);
    }

    @Test
    public void testInterceptorIntercept50Times() throws IOException, InterruptedException {
        for (int i = 0; i < 50; ++i) {
            this.testInterceptorIntercept();
        }
    }

    public void testInterceptorIntercept() throws IOException, InterruptedException {
        Configuration conf = HBaseConfiguration.create();
        long CLEANUP_TIMEOUT = 50L;
        long FAST_FAIL_THRESHOLD = 10L;
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        conf.setLong("hbase.client.fast.fail.cleanup.duration", CLEANUP_TIMEOUT);
        conf.setLong("hbase.client.fastfail.threshold", FAST_FAIL_THRESHOLD);
        PreemptiveFastFailInterceptor interceptor = TestFastFailWithoutTestUtil.createPreemptiveInterceptor(conf);
        FastFailInterceptorContext context = (FastFailInterceptorContext)interceptor.createEmptyContext();
        RetryingCallable callable = this.getDummyRetryingCallable(TestFastFailWithoutTestUtil.getSomeServerName());
        int tries = 0;
        context.prepare(callable, tries);
        interceptor.intercept(context);
        interceptor.handleFailure(context, (Throwable)new ConnectException("Failed to connect to server"));
        interceptor.updateFailureInfo(context);
        Assert.assertTrue((String)"Interceptor should have updated didTry to true", (boolean)context.didTry());
        Assert.assertTrue((String)"The call shouldn't have been successful if there was a ConnectException", (boolean)context.getCouldNotCommunicateWithServer().booleanValue());
        Assert.assertNull((String)"Once a failure is identified, the first time the FailureInfo is generated for the server, but it is not assigned to the context yet. It would be assigned on the next intercept.", (Object)context.getFailureInfo());
        Assert.assertEquals((long)context.getTries(), (long)tries);
        Assert.assertFalse((String)"We are still in the first attempt and so we dont set this variable to true yet.", (boolean)context.isRetryDespiteFastFailMode());
        Thread.sleep(FAST_FAIL_THRESHOLD + 1L);
        context.prepare(callable, ++tries);
        interceptor.intercept(context);
        interceptor.handleFailure(context, (Throwable)new ConnectException("Failed to connect to server"));
        interceptor.updateFailureInfo(context);
        Assert.assertTrue((String)"didTru should remain true", (boolean)context.didTry());
        Assert.assertTrue((String)"The call shouldn't have been successful if there was a ConnectException", (boolean)context.getCouldNotCommunicateWithServer().booleanValue());
        Assert.assertNotNull((String)"The context this time is updated with a failureInfo, since we already gave it a try.", (Object)context.getFailureInfo());
        Assert.assertEquals((long)context.getTries(), (long)tries);
        Assert.assertTrue((String)"Since we are alone here we would be given the permission to retryDespiteFailures.", (boolean)context.isRetryDespiteFastFailMode());
        context.clear();
        Thread.sleep(CLEANUP_TIMEOUT);
        context.clear();
        context.prepare(callable, ++tries);
        interceptor.occasionallyCleanupFailureInformation();
        Assert.assertNull((String)"The cleanup should have cleared the server", interceptor.repeatedFailuresMap.get(context.getServer()));
        interceptor.intercept(context);
        interceptor.handleFailure(context, (Throwable)new ConnectException("Failed to connect to server"));
        interceptor.updateFailureInfo(context);
        Assert.assertTrue((String)"didTru should remain true", (boolean)context.didTry());
        Assert.assertTrue((String)"The call shouldn't have been successful if there was a ConnectException", (boolean)context.getCouldNotCommunicateWithServer().booleanValue());
        Assert.assertNull((String)"The failureInfo is cleared off from the maps.", (Object)context.getFailureInfo());
        Assert.assertEquals((long)context.getTries(), (long)tries);
        Assert.assertFalse((String)"Since we are alone here we would be given the permission to retryDespiteFailures.", (boolean)context.isRetryDespiteFastFailMode());
        context.clear();
    }

    private <T> RetryingCallable<T> getDummyRetryingCallable(ServerName someServerName) {
        return new RegionServerCallable<T>(null, null, null){

            public T call(int callTimeout) throws Exception {
                return null;
            }

            protected HRegionLocation getLocation() {
                return new HRegionLocation(null, TestFastFailWithoutTestUtil.this.serverName);
            }
        };
    }

    @Test
    public void testExceptionsIdentifiedByInterceptor() throws IOException {
        RetryingCallable callable;
        FastFailInterceptorContext context;
        PreemptiveFastFailInterceptor interceptor;
        Throwable[] networkexceptions = new Throwable[]{new ConnectException("Mary is unwell"), new SocketTimeoutException("Mike is too late"), new ClosedChannelException(), new SyncFailedException("Dave is not on the same page"), new TimeoutException("Mike is late again"), new EOFException("This is the end... "), new ConnectionClosingException("Its closing")};
        String INDUCED = "Induced";
        Throwable[] nonNetworkExceptions = new Throwable[]{new IOException("Bob died"), new RemoteException("Bob's cousin died", null), new NoSuchMethodError("Induced"), new NullPointerException("Induced"), new DoNotRetryIOException("Induced"), new Error("Induced")};
        Configuration conf = HBaseConfiguration.create();
        long CLEANUP_TIMEOUT = 0L;
        long FAST_FAIL_THRESHOLD = 1000000L;
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        conf.setLong("hbase.client.fast.fail.cleanup.duration", CLEANUP_TIMEOUT);
        conf.setLong("hbase.client.fastfail.threshold", FAST_FAIL_THRESHOLD);
        for (Throwable e : networkexceptions) {
            interceptor = TestFastFailWithoutTestUtil.createPreemptiveInterceptor(conf);
            context = (FastFailInterceptorContext)interceptor.createEmptyContext();
            callable = this.getDummyRetryingCallable(TestFastFailWithoutTestUtil.getSomeServerName());
            context.prepare(callable, 0);
            interceptor.intercept(context);
            interceptor.handleFailure(context, e);
            interceptor.updateFailureInfo(context);
            Assert.assertTrue((String)"The call shouldn't have been successful if there was a ConnectException", (boolean)context.getCouldNotCommunicateWithServer().booleanValue());
        }
        for (Throwable e : nonNetworkExceptions) {
            try {
                interceptor = TestFastFailWithoutTestUtil.createPreemptiveInterceptor(conf);
                context = (FastFailInterceptorContext)interceptor.createEmptyContext();
                callable = this.getDummyRetryingCallable(TestFastFailWithoutTestUtil.getSomeServerName());
                context.prepare(callable, 0);
                interceptor.intercept(context);
                interceptor.handleFailure(context, e);
                interceptor.updateFailureInfo(context);
                Assert.assertFalse((String)"The call shouldn't have been successful if there was a ConnectException", (boolean)context.getCouldNotCommunicateWithServer().booleanValue());
            }
            catch (NoSuchMethodError t) {
                Assert.assertTrue((String)"Exception not induced", (boolean)t.getMessage().contains("Induced"));
            }
            catch (NullPointerException t) {
                Assert.assertTrue((String)"Exception not induced", (boolean)t.getMessage().contains("Induced"));
            }
            catch (DoNotRetryIOException t) {
                Assert.assertTrue((String)"Exception not induced", (boolean)t.getMessage().contains("Induced"));
            }
            catch (Error t) {
                Assert.assertTrue((String)"Exception not induced", (boolean)t.getMessage().contains("Induced"));
            }
        }
    }

    protected static PreemptiveFastFailInterceptor createPreemptiveInterceptor(Configuration conf) {
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        RetryingCallerInterceptorFactory interceptorFactory = new RetryingCallerInterceptorFactory(conf);
        RetryingCallerInterceptor interceptorBeforeCast = interceptorFactory.build();
        return (PreemptiveFastFailInterceptor)interceptorBeforeCast;
    }

    static PreemptiveFastFailInterceptor createPreemptiveInterceptor() {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        return TestFastFailWithoutTestUtil.createPreemptiveInterceptor(conf);
    }

    @Test(timeout=120000L)
    public void testPreemptiveFastFailException50Times() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 50; ++i) {
            this.testPreemptiveFastFailException();
        }
    }

    private void testPreemptiveFastFailException() throws InterruptedException, ExecutionException {
        LOG.debug((Object)"Setting up the counters to start the test");
        this.priviRetryCounter.set(0);
        this.nonPriviRetryCounter.set(0);
        this.done.set(0);
        for (int i = 0; i <= 3; ++i) {
            this.latches[i] = new CountDownLatch(1);
            this.latches2[i] = new CountDownLatch(1);
        }
        PreemptiveFastFailInterceptor interceptor = this.getInterceptor();
        final RpcRetryingCaller<Void> priviCaller = this.getRpcRetryingCaller(10, 3, (RetryingCallerInterceptor)interceptor);
        final RpcRetryingCaller<Void> nonPriviCaller = this.getRpcRetryingCaller(10, 3, (RetryingCallerInterceptor)interceptor);
        LOG.debug((Object)"Submitting the thread 1");
        Future<Boolean> priviFuture = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().set(true);
                    priviCaller.callWithRetries((RetryingCallable)TestFastFailWithoutTestUtil.this.getRetryingCallable(TestFastFailWithoutTestUtil.this.serverName, TestFastFailWithoutTestUtil.this.exception), 10000);
                }
                catch (RetriesExhaustedException e) {
                    return true;
                }
                catch (PreemptiveFastFailException e) {
                    return false;
                }
                return false;
            }
        });
        LOG.debug((Object)"Submitting the thread 2");
        Future<Boolean> nonPriviFuture = this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().set(false);
                    nonPriviCaller.callWithRetries((RetryingCallable)TestFastFailWithoutTestUtil.this.getRetryingCallable(TestFastFailWithoutTestUtil.this.serverName, TestFastFailWithoutTestUtil.this.exception), 10000);
                }
                catch (PreemptiveFastFailException e) {
                    return true;
                }
                return false;
            }
        });
        LOG.debug((Object)"Waiting for Thread 2 to finish");
        Assert.assertTrue((boolean)nonPriviFuture.get());
        LOG.debug((Object)"Waiting for Thread 1 to finish");
        Assert.assertTrue((boolean)priviFuture.get());
        Assert.assertTrue((boolean)interceptor.isServerInFailureMap(this.serverName));
        final RpcRetryingCaller<Void> priviCallerNew = this.getRpcRetryingCaller(10, 3, (RetryingCallerInterceptor)interceptor);
        this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                priviCallerNew.callWithRetries((RetryingCallable)TestFastFailWithoutTestUtil.this.getRetryingCallable(TestFastFailWithoutTestUtil.this.serverName, null), 10000);
                return false;
            }
        }).get();
        Assert.assertFalse((String)"The server was supposed to be removed from the map", (boolean)interceptor.isServerInFailureMap(this.serverName));
    }

    public PreemptiveFastFailInterceptor getInterceptor() {
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.client.fast.fail.mode.enabled", true);
        conf.setLong("hbase.client.fast.fail.cleanup.duration", 10000L);
        conf.setLong("hbase.client.fastfail.threshold", 10L);
        return new PreemptiveFastFailInterceptor(conf){

            public void updateFailureInfo(RetryingCallerInterceptorContext context) {
                boolean pffe = false;
                if (!TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().get()) {
                    boolean bl = pffe = !((FastFailInterceptorContext)context).isRetryDespiteFastFailMode();
                }
                if (TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().get()) {
                    try {
                        if (TestFastFailWithoutTestUtil.this.done.get() <= 1) {
                            TestFastFailWithoutTestUtil.this.latches2[TestFastFailWithoutTestUtil.this.priviRetryCounter.get()].await();
                        }
                    }
                    catch (InterruptedException e) {
                        Assert.fail();
                    }
                }
                super.updateFailureInfo(context);
                if (!TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().get()) {
                    if (pffe) {
                        TestFastFailWithoutTestUtil.this.done.incrementAndGet();
                    }
                    TestFastFailWithoutTestUtil.this.latches2[TestFastFailWithoutTestUtil.this.nonPriviRetryCounter.get()].countDown();
                }
            }

            public void intercept(RetryingCallerInterceptorContext context) throws PreemptiveFastFailException {
                if (!TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().get()) {
                    try {
                        TestFastFailWithoutTestUtil.this.latches[TestFastFailWithoutTestUtil.this.nonPriviRetryCounter.getAndIncrement()].await();
                    }
                    catch (InterruptedException e) {
                        Assert.fail();
                    }
                }
                super.intercept(context);
            }

            public void handleFailure(RetryingCallerInterceptorContext context, Throwable t) throws IOException {
                super.handleFailure(context, t);
                if (TestFastFailWithoutTestUtil.this.isPriviThreadLocal.get().get()) {
                    TestFastFailWithoutTestUtil.this.latches[TestFastFailWithoutTestUtil.this.priviRetryCounter.getAndIncrement()].countDown();
                }
            }
        };
    }

    public RpcRetryingCaller<Void> getRpcRetryingCaller(int pauseTime, int retries, RetryingCallerInterceptor interceptor) {
        return new RpcRetryingCaller<Void>((long)pauseTime, retries, interceptor, 9){

            public Void callWithRetries(RetryingCallable<Void> callable, int callTimeout) throws IOException, RuntimeException {
                Void ret = (Void)super.callWithRetries(callable, callTimeout);
                return ret;
            }
        };
    }

    protected static ServerName getSomeServerName() {
        return ServerName.valueOf((String)"localhost", (int)1234, (long)987654321L);
    }

    private RegionServerCallable<Void> getRetryingCallable(final ServerName serverName, final Exception e) {
        return new RegionServerCallable<Void>(null, null, null){

            public void prepare(boolean reload) throws IOException {
                this.location = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, serverName);
            }

            public Void call(int callTimeout) throws Exception {
                if (e != null) {
                    throw e;
                }
                return null;
            }

            protected HRegionLocation getLocation() {
                return new HRegionLocation(null, serverName);
            }

            public void throwable(Throwable t, boolean retrying) {
            }

            public long sleep(long pause, int tries) {
                return ConnectionUtils.getPauseTime((long)pause, (int)(tries + 1));
            }
        };
    }
}

