/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestClientScanner {
    Scan scan;
    ExecutorService pool;
    Configuration conf;
    ClusterConnection clusterConn;
    RpcRetryingCallerFactory rpcFactory;
    RpcControllerFactory controllerFactory;

    @Before
    public void setup() throws IOException {
        this.clusterConn = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        this.rpcFactory = (RpcRetryingCallerFactory)Mockito.mock(RpcRetryingCallerFactory.class);
        this.controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        this.pool = Executors.newSingleThreadExecutor();
        this.scan = new Scan();
        this.conf = new Configuration();
        Mockito.when((Object)this.clusterConn.getConfiguration()).thenReturn((Object)this.conf);
    }

    @After
    public void teardown() {
        if (null != this.pool) {
            this.pool.shutdownNow();
        }
    }

    @Test
    public void testNoResultsHint() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue("row".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: 
                    case 2: {
                        ++this.count;
                        return null;
                    }
                    case 1: {
                        ++this.count;
                        callable.setHasMoreResultsContext(false);
                        return results;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            scanner.setRpcFinished(true);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testSizeLimit() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue("row".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: 
                    case 2: {
                        ++this.count;
                        return null;
                    }
                    case 1: {
                        ++this.count;
                        callable.setHasMoreResultsContext(true);
                        callable.setServerHasMoreResults(false);
                        return results;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            ((RpcRetryingCaller)Mockito.verify((Object)caller)).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testCacheLimit() throws IOException {
        KeyValue kv1 = new KeyValue("row1".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        KeyValue kv3 = new KeyValue("row3".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final Result[] results = new Result[]{Result.create((Cell[])new Cell[]{kv1}), Result.create((Cell[])new Cell[]{kv2}), Result.create((Cell[])new Cell[]{kv3})};
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: 
                    case 2: {
                        ++this.count;
                        return null;
                    }
                    case 1: {
                        ++this.count;
                        callable.setHasMoreResultsContext(true);
                        callable.setServerHasMoreResults(false);
                        return results;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(1);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            ((RpcRetryingCaller)Mockito.verify((Object)caller)).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)3L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv2, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv3, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testNoMoreResults() throws IOException {
        final Result[] results = new Result[1];
        KeyValue kv1 = new KeyValue("row".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        results[0] = Result.create((Cell[])new Cell[]{kv1});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: 
                    case 2: {
                        ++this.count;
                        return null;
                    }
                    case 1: {
                        ++this.count;
                        callable.setHasMoreResultsContext(true);
                        callable.setServerHasMoreResults(false);
                        return results;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            ((RpcRetryingCaller)Mockito.verify((Object)caller)).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            scanner.setRpcFinished(true);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    @Test
    public void testMoreResults() throws IOException {
        final Result[] results1 = new Result[1];
        KeyValue kv1 = new KeyValue("row".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        results1[0] = Result.create((Cell[])new Cell[]{kv1});
        final Result[] results2 = new Result[1];
        KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        results2[0] = Result.create((Cell[])new Cell[]{kv2});
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        Mockito.when((Object)caller.callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt())).thenAnswer((Answer)new Answer<Result[]>(){
            private int count = 0;

            public Result[] answer(InvocationOnMock invocation) throws Throwable {
                ScannerCallableWithReplicas callable = (ScannerCallableWithReplicas)invocation.getArgumentAt(0, ScannerCallableWithReplicas.class);
                switch (this.count) {
                    case 0: 
                    case 3: {
                        ++this.count;
                        return null;
                    }
                    case 1: {
                        ++this.count;
                        callable.setHasMoreResultsContext(true);
                        callable.setServerHasMoreResults(true);
                        return results1;
                    }
                    case 2: {
                        ++this.count;
                        callable.setHasMoreResultsContext(true);
                        callable.setServerHasMoreResults(false);
                        return results2;
                    }
                }
                throw new RuntimeException("Expected only 2 invocations");
            }
        });
        this.scan.setCaching(100);
        this.scan.setMaxResultSize(1000000L);
        try (MockClientScanner scanner = new MockClientScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn, this.rpcFactory, this.controllerFactory, this.pool, Integer.MAX_VALUE);){
            ((RpcRetryingCaller)Mockito.verify((Object)caller)).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)2))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            Assert.assertEquals((long)1L, (long)scanner.cache.size());
            Result r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            CellScanner cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv1, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
            scanner.setRpcFinished(true);
            inOrder = Mockito.inOrder((Object[])new Object[]{caller});
            scanner.loadCache();
            ((RpcRetryingCaller)inOrder.verify((Object)caller, Mockito.times((int)3))).callWithoutRetries((RetryingCallable)Mockito.any(RetryingCallable.class), Mockito.anyInt());
            r = (Result)scanner.cache.poll();
            Assert.assertNotNull((Object)r);
            cs = r.cellScanner();
            Assert.assertTrue((boolean)cs.advance());
            Assert.assertEquals((Object)kv2, (Object)cs.current());
            Assert.assertFalse((boolean)cs.advance());
        }
    }

    private static class MockClientScanner
    extends ClientScanner {
        private boolean rpcFinished = false;
        private boolean rpcFinishedFired = false;

        public MockClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
            super(conf, scan, tableName, connection, rpcFactory, controllerFactory, pool, primaryOperationTimeout);
        }

        protected boolean nextScanner(int nbRows, boolean done) throws IOException {
            if (!this.rpcFinished) {
                return super.nextScanner(nbRows, done);
            }
            if (this.rpcFinishedFired) {
                throw new RuntimeException("Expected nextScanner to only be called once after  short-circuit was triggered.");
            }
            this.rpcFinishedFired = true;
            return false;
        }

        protected ScannerCallableWithReplicas getScannerCallable(byte[] localStartKey, int nbRows) {
            this.scan.setStartRow(localStartKey);
            ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory);
            s.setCaching(nbRows);
            ScannerCallableWithReplicas sr = new ScannerCallableWithReplicas(this.getTable(), this.getConnection(), s, this.pool, this.primaryOperationTimeout, this.scan, this.getRetries(), this.scannerTimeout, this.caching, this.conf, this.caller);
            return sr;
        }

        public void setRpcFinished(boolean rpcFinished) {
            this.rpcFinished = rpcFinished;
        }
    }
}

