/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestEncryptionUtil {
    @Test
    public void testKeyWrapping() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        byte[] keyBytes = new byte[16];
        new SecureRandom().nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        byte[] wrappedKeyBytes = EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)key);
        Assert.assertNotNull((Object)wrappedKeyBytes);
        Key unwrappedKey = EncryptionUtil.unwrapKey((Configuration)conf, (String)"hbase", (byte[])wrappedKeyBytes);
        Assert.assertNotNull((Object)unwrappedKey);
        Assert.assertTrue((boolean)(unwrappedKey instanceof SecretKeySpec));
        Assert.assertTrue((String)"Unwrapped key bytes do not match original", (boolean)Bytes.equals((byte[])keyBytes, (byte[])unwrappedKey.getEncoded()));
        try {
            EncryptionUtil.unwrapKey((Configuration)conf, (String)"other", (byte[])wrappedKeyBytes);
            Assert.fail((String)"Unwrap with incorrect key did not throw KeyException");
        }
        catch (KeyException e) {
            // empty catch block
        }
    }
}

