/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.UUID;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClusterIdProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClusterId {
    private final String id;

    public ClusterId() {
        this(UUID.randomUUID().toString());
    }

    public ClusterId(String uuid) {
        this.id = uuid;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.convert().toByteArray());
    }

    public static ClusterId parseFrom(byte[] bytes) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(bytes)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            ClusterIdProtos.ClusterId.Builder builder = ClusterIdProtos.ClusterId.newBuilder();
            ClusterIdProtos.ClusterId cid = null;
            try {
                cid = ((ClusterIdProtos.ClusterId.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
            return ClusterId.convert(cid);
        }
        return new ClusterId(Bytes.toString((byte[])bytes));
    }

    ClusterIdProtos.ClusterId convert() {
        ClusterIdProtos.ClusterId.Builder builder = ClusterIdProtos.ClusterId.newBuilder();
        return builder.setClusterId(this.id).build();
    }

    static ClusterId convert(ClusterIdProtos.ClusterId cid) {
        return new ClusterId(cid.getClusterId());
    }

    public String toString() {
        return this.id;
    }
}

