/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.protobuf.generated.CellProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestClientNoCluster
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TestClientNoCluster.class);
    private Configuration conf;
    public static final ServerName META_SERVERNAME = ServerName.valueOf((String)"meta.example.org", (int)60010, (long)12345L);
    private static final ByteString CATALOG_FAMILY_BYTESTRING = ByteStringer.wrap((byte[])HConstants.CATALOG_FAMILY);
    private static final ByteString REGIONINFO_QUALIFIER_BYTESTRING = ByteStringer.wrap((byte[])HConstants.REGIONINFO_QUALIFIER);
    private static final ByteString SERVER_QUALIFIER_BYTESTRING = ByteStringer.wrap((byte[])HConstants.SERVER_QUALIFIER);
    private static final byte[] BIG_USER_TABLE = Bytes.toBytes((String)"t");

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.set("hbase.client.registry.impl", SimpleRegistry.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testTimeoutAndRetries() throws IOException {
        Configuration localConfig = HBaseConfiguration.create((Configuration)this.conf);
        localConfig.set("hbase.client.connection.impl", RpcTimeoutConnection.class.getName());
        HTable table = new HTable(localConfig, TableName.META_TABLE_NAME);
        SocketTimeoutException t = null;
        LOG.info((Object)"Start");
        try {
            table.exists(new Get(Bytes.toBytes((String)"abc")));
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Got expected exception", (Throwable)e);
            t = e;
        }
        catch (RetriesExhaustedException e) {
            Assert.fail();
        }
        finally {
            table.close();
        }
        LOG.info((Object)"Stop");
        Assert.assertTrue((t != null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRocTimeout() throws IOException {
        Configuration localConfig = HBaseConfiguration.create((Configuration)this.conf);
        localConfig.set("hbase.client.connection.impl", RpcTimeoutConnection.class.getName());
        int pause = 10;
        localConfig.setInt("hbase.client.pause", pause);
        localConfig.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 10);
        localConfig.setInt("hbase.client.meta.operation.timeout", pause - 1);
        HTable table = new HTable(localConfig, TableName.META_TABLE_NAME);
        SocketTimeoutException t = null;
        try {
            table.exists(new Get(Bytes.toBytes((String)"abc")));
        }
        catch (SocketTimeoutException e) {
            LOG.info((Object)"Got expected exception", (Throwable)e);
            t = e;
        }
        catch (RetriesExhaustedException e) {
            Assert.fail();
        }
        finally {
            table.close();
        }
        Assert.assertTrue((t != null ? 1 : 0) != 0);
    }

    @Test
    public void testDoNotRetryMetaScanner() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        MetaScanner.metaScan((Configuration)this.conf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotRetryOnScanNext() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        HTable table = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = table.getScanner(HConstants.CATALOG_FAMILY);
        try {
            Result result = null;
            while ((result = scanner.next()) != null) {
                LOG.info((Object)result);
            }
        }
        finally {
            scanner.close();
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegionServerStoppedOnScannerOpen() throws IOException {
        this.conf.set("hbase.client.connection.impl", RegionServerStoppedOnScannerOpenConnection.class.getName());
        HTable table = new HTable(this.conf, TableName.META_TABLE_NAME);
        ResultScanner scanner = table.getScanner(HConstants.CATALOG_FAMILY);
        try {
            Result result = null;
            while ((result = scanner.next()) != null) {
                LOG.info((Object)result);
            }
        }
        finally {
            scanner.close();
            table.close();
        }
    }

    static ClientProtos.MultiResponse doMultiResponse(SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta, AtomicLong sequenceids, ClientProtos.MultiRequest request) {
        ClientProtos.MultiResponse.Builder builder = ClientProtos.MultiResponse.newBuilder();
        ClientProtos.RegionActionResult.Builder regionActionResultBuilder = ClientProtos.RegionActionResult.newBuilder();
        ClientProtos.ResultOrException.Builder roeBuilder = ClientProtos.ResultOrException.newBuilder();
        for (ClientProtos.RegionAction regionAction : request.getRegionActionList()) {
            regionActionResultBuilder.clear();
            for (ClientProtos.Action action : regionAction.getActionList()) {
                roeBuilder.clear();
                roeBuilder.setResult(ClientProtos.Result.getDefaultInstance());
                roeBuilder.setIndex(action.getIndex());
                regionActionResultBuilder.addResultOrException(roeBuilder.build());
            }
            builder.addRegionActionResult(regionActionResultBuilder.build());
        }
        return builder.build();
    }

    static ClientProtos.ScanResponse doMetaScanResponse(SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta, AtomicLong sequenceids, ClientProtos.ScanRequest request) {
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        int max = request.getNumberOfRows();
        int count = 0;
        SortedMap<byte[], Pair<HRegionInfo, ServerName>> tail = request.hasScan() ? meta.tailMap(request.getScan().getStartRow().toByteArray()) : meta;
        ClientProtos.Result.Builder resultBuilder = ClientProtos.Result.newBuilder();
        for (Map.Entry e : tail.entrySet()) {
            if (max <= 0 || ++count > max) break;
            HRegionInfo hri = (HRegionInfo)((Pair)e.getValue()).getFirst();
            ByteString row = ByteStringer.wrap((byte[])hri.getRegionName());
            resultBuilder.clear();
            resultBuilder.addCell(TestClientNoCluster.getRegionInfo(row, hri));
            resultBuilder.addCell(TestClientNoCluster.getServer(row, (ServerName)((Pair)e.getValue()).getSecond()));
            resultBuilder.addCell(TestClientNoCluster.getStartCode(row));
            builder.addResults(resultBuilder.build());
            if (hri.getEndKey().length <= 0) {
                builder.setMoreResults(false);
                continue;
            }
            builder.setMoreResults(true);
        }
        builder.setScannerId(request.hasScannerId() ? request.getScannerId() : sequenceids.incrementAndGet());
        return builder.build();
    }

    static ClientProtos.GetResponse doMetaGetResponse(SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta, ClientProtos.GetRequest request) {
        ClientProtos.Result.Builder resultBuilder = ClientProtos.Result.newBuilder();
        ByteString row = request.getGet().getRow();
        Pair p = (Pair)meta.get(row.toByteArray());
        if (p == null && request.getGet().getClosestRowBefore()) {
            byte[] bytes = row.toByteArray();
            SortedMap<byte[], Pair<HRegionInfo, ServerName>> head = bytes != null ? meta.headMap(bytes) : meta;
            Pair pair = p = head == null ? null : (Pair)head.get(head.lastKey());
        }
        if (p != null) {
            resultBuilder.addCell(TestClientNoCluster.getRegionInfo(row, (HRegionInfo)p.getFirst()));
            resultBuilder.addCell(TestClientNoCluster.getServer(row, (ServerName)p.getSecond()));
        }
        resultBuilder.addCell(TestClientNoCluster.getStartCode(row));
        ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
        builder.setResult(resultBuilder.build());
        return builder.build();
    }

    static boolean isMetaRegion(byte[] name, HBaseProtos.RegionSpecifier.RegionSpecifierType type) {
        switch (type) {
            case REGION_NAME: {
                return Bytes.equals((byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), (byte[])name);
            }
            case ENCODED_REGION_NAME: {
                return Bytes.equals((byte[])HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), (byte[])name);
            }
        }
        throw new UnsupportedOperationException();
    }

    static CellProtos.Cell.Builder getBaseCellBuilder(ByteString row) {
        CellProtos.Cell.Builder cellBuilder = CellProtos.Cell.newBuilder();
        cellBuilder.setRow(row);
        cellBuilder.setFamily(CATALOG_FAMILY_BYTESTRING);
        cellBuilder.setTimestamp(System.currentTimeMillis());
        return cellBuilder;
    }

    static CellProtos.Cell getRegionInfo(ByteString row, HRegionInfo hri) {
        CellProtos.Cell.Builder cellBuilder = TestClientNoCluster.getBaseCellBuilder(row);
        cellBuilder.setQualifier(REGIONINFO_QUALIFIER_BYTESTRING);
        cellBuilder.setValue(ByteStringer.wrap((byte[])hri.toByteArray()));
        return cellBuilder.build();
    }

    static CellProtos.Cell getServer(ByteString row, ServerName sn) {
        CellProtos.Cell.Builder cellBuilder = TestClientNoCluster.getBaseCellBuilder(row);
        cellBuilder.setQualifier(SERVER_QUALIFIER_BYTESTRING);
        cellBuilder.setValue(ByteString.copyFromUtf8((String)sn.getHostAndPort()));
        return cellBuilder.build();
    }

    static CellProtos.Cell getStartCode(ByteString row) {
        CellProtos.Cell.Builder cellBuilder = TestClientNoCluster.getBaseCellBuilder(row);
        cellBuilder.setQualifier(ByteStringer.wrap((byte[])HConstants.STARTCODE_QUALIFIER));
        cellBuilder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((long)META_SERVERNAME.getStartcode())));
        return cellBuilder.build();
    }

    private static byte[] format(long number) {
        byte[] b = new byte[10];
        long d = number;
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10L + 48L);
            d /= 10L;
        }
        return b;
    }

    private static HRegionInfo[] makeHRegionInfos(byte[] tableName, int count, long namespaceSpan) {
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
        long interval = namespaceSpan / (long)count;
        HRegionInfo[] hris = new HRegionInfo[count];
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                endKey = TestClientNoCluster.format(interval);
            } else {
                startKey = endKey;
                endKey = i == count - 1 ? HConstants.EMPTY_BYTE_ARRAY : TestClientNoCluster.format((long)(i + 1) * interval);
            }
            hris[i] = new HRegionInfo(TableName.valueOf((byte[])tableName), startKey, endKey);
        }
        return hris;
    }

    private static ServerName[] makeServerNames(int count) {
        ServerName[] sns = new ServerName[count];
        for (int i = 0; i < count; ++i) {
            sns[i] = ServerName.valueOf((String)("" + i + ".example.org"), (int)60010, (long)i);
        }
        return sns;
    }

    static SortedMap<byte[], Pair<HRegionInfo, ServerName>> makeMeta(byte[] tableName, int regionCount, long namespaceSpan, int serverCount) {
        ConcurrentSkipListMap<byte[], Pair<HRegionInfo, ServerName>> meta = new ConcurrentSkipListMap<byte[], Pair<HRegionInfo, ServerName>>(new MetaRowsComparator());
        HRegionInfo[] hris = TestClientNoCluster.makeHRegionInfos(tableName, regionCount, namespaceSpan);
        ServerName[] serverNames = TestClientNoCluster.makeServerNames(serverCount);
        int per = regionCount / serverCount;
        int count = 0;
        for (HRegionInfo hri : hris) {
            Pair p = new Pair((Object)hri, (Object)serverNames[count++ / per]);
            meta.put(hri.getRegionName(), (Pair<HRegionInfo, ServerName>)p);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cycle(int id, Configuration c, HConnection sharedConnection) throws IOException {
        HTableInterface table = sharedConnection.getTable(BIG_USER_TABLE);
        table.setAutoFlushTo(false);
        long namespaceSpan = c.getLong("hbase.test.namespace.span", 1000000L);
        long startTime = System.currentTimeMillis();
        int printInterval = 100000;
        Random rd = new Random(id);
        boolean get = c.getBoolean("hbase.test.do.gets", false);
        try {
            Stopwatch stopWatch = new Stopwatch();
            stopWatch.start();
            int i = 0;
            while ((long)i < namespaceSpan) {
                byte[] b = TestClientNoCluster.format(rd.nextLong());
                if (get) {
                    Get g = new Get(b);
                    table.get(g);
                } else {
                    Put p = new Put(b);
                    p.add(HConstants.CATALOG_FAMILY, b, b);
                    table.put(p);
                }
                if (i % 100000 == 0) {
                    LOG.info((Object)("Put 100000/" + stopWatch.elapsedMillis()));
                    stopWatch.reset();
                    stopWatch.start();
                }
                ++i;
            }
            LOG.info((Object)("Finished a cycle putting " + namespaceSpan + " in " + (System.currentTimeMillis() - startTime) + "ms"));
        }
        finally {
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] arg0) throws Exception {
        int errCode = 0;
        boolean servers = true;
        int regions = 100000;
        long namespaceSpan = 50000000L;
        long multiPause = 0L;
        this.getConf().set("hbase.client.connection.impl", ManyServersManyRegionsConnection.class.getName());
        this.getConf().set("hbase.client.registry.impl", SimpleRegistry.class.getName());
        this.getConf().setInt("hbase.client.start.log.errors.counter", 0);
        this.getConf().setInt("hbase.test.regions", 100000);
        this.getConf().setLong("hbase.test.namespace.span", 50000000L);
        this.getConf().setLong("hbase.test.servers", 1L);
        this.getConf().set("hbase.test.tablename", Bytes.toString((byte[])BIG_USER_TABLE));
        this.getConf().setLong("hbase.test.multi.pause.when.done", 0L);
        this.getConf().setInt("hbase.test.multi.too.many", 10);
        int clients = 2;
        ExecutorService pool = Executors.newCachedThreadPool(Threads.getNamedThreadFactory((String)"p"));
        final HConnection sharedConnection = HConnectionManager.createConnection((Configuration)this.getConf());
        try {
            int j;
            Thread[] ts = new Thread[2];
            for (j = 0; j < ts.length; ++j) {
                final int id = j;
                ts[j] = new Thread("" + j){
                    final Configuration c;
                    {
                        super(x0);
                        this.c = TestClientNoCluster.this.getConf();
                    }

                    @Override
                    public void run() {
                        try {
                            TestClientNoCluster.cycle(id, this.c, sharedConnection);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
                ts[j].start();
            }
            for (j = 0; j < ts.length; ++j) {
                ts[j].join();
            }
        }
        finally {
            sharedConnection.close();
        }
        return errCode;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new TestClientNoCluster(), (String[])args));
    }

    private static class MetaRowsComparator
    implements Comparator<byte[]> {
        private final KeyValue.KVComparator delegate = new KeyValue.MetaComparator();

        private MetaRowsComparator() {
        }

        @Override
        public int compare(byte[] left, byte[] right) {
            return this.delegate.compareRows(left, 0, left.length, right, 0, right.length);
        }
    }

    static class FakeServer
    implements ClientProtos.ClientService.BlockingInterface {
        private AtomicInteger multiInvocationsCount = new AtomicInteger(0);
        private final SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta;
        private final AtomicLong sequenceids;
        private final long multiPause;
        private final int tooManyMultiRequests;

        FakeServer(Configuration c, SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta, AtomicLong sequenceids) {
            this.meta = meta;
            this.sequenceids = sequenceids;
            this.multiPause = c.getLong("hbase.test.multi.pause.when.done", 0L);
            this.tooManyMultiRequests = c.getInt("hbase.test.multi.too.many", 3);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            boolean metaRegion = TestClientNoCluster.isMetaRegion(request.getRegion().getValue().toByteArray(), request.getRegion().getType());
            if (!metaRegion) {
                return this.doGetResponse(request);
            }
            return TestClientNoCluster.doMetaGetResponse(this.meta, request);
        }

        private ClientProtos.GetResponse doGetResponse(ClientProtos.GetRequest request) {
            ClientProtos.Result.Builder resultBuilder = ClientProtos.Result.newBuilder();
            ByteString row = request.getGet().getRow();
            resultBuilder.addCell(TestClientNoCluster.getStartCode(row));
            ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
            builder.setResult(resultBuilder.build());
            return builder.build();
        }

        public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
            throw new NotImplementedException();
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            return TestClientNoCluster.doMetaScanResponse(this.meta, this.sequenceids, request);
        }

        public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
            throw new NotImplementedException();
        }

        public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
            throw new NotImplementedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
            int concurrentInvocations = this.multiInvocationsCount.incrementAndGet();
            try {
                if (concurrentInvocations >= this.tooManyMultiRequests) {
                    throw new ServiceException((Throwable)new RegionTooBusyException("concurrentInvocations=" + concurrentInvocations));
                }
                Threads.sleep((long)this.multiPause);
                ClientProtos.MultiResponse multiResponse = TestClientNoCluster.doMultiResponse(this.meta, this.sequenceids, request);
                return multiResponse;
            }
            finally {
                this.multiInvocationsCount.decrementAndGet();
            }
        }
    }

    static class ManyServersManyRegionsConnection
    extends HConnectionManager.HConnectionImplementation {
        final Map<ServerName, ClientProtos.ClientService.BlockingInterface> serversByClient;
        final SortedMap<byte[], Pair<HRegionInfo, ServerName>> meta;
        final AtomicLong sequenceids = new AtomicLong(0L);
        private final Configuration conf;

        ManyServersManyRegionsConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            super(conf, managed, pool, user);
            int serverCount = conf.getInt("hbase.test.servers", 10);
            this.serversByClient = new HashMap<ServerName, ClientProtos.ClientService.BlockingInterface>(serverCount);
            this.meta = TestClientNoCluster.makeMeta(Bytes.toBytes((String)conf.get("hbase.test.tablename", Bytes.toString((byte[])BIG_USER_TABLE))), conf.getInt("hbase.test.regions", 100), conf.getLong("hbase.test.namespace.span", 1000L), serverCount);
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            ClientProtos.ClientService.BlockingInterface stub = null;
            Map<ServerName, ClientProtos.ClientService.BlockingInterface> map = this.serversByClient;
            synchronized (map) {
                stub = this.serversByClient.get(sn);
                if (stub == null) {
                    stub = new FakeServer(this.conf, this.meta, this.sequenceids);
                    this.serversByClient.put(sn, stub);
                }
            }
            return stub;
        }
    }

    static class RpcTimeoutConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        RpcTimeoutConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            super(conf, managed);
            try {
                Mockito.when((Object)this.stub.get((RpcController)Mockito.any(), (ClientProtos.GetRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))});
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class RegionServerStoppedOnScannerOpenConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        RegionServerStoppedOnScannerOpenConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
            super(conf, managed);
            long sid = 12345L;
            try {
                Mockito.when((Object)this.stub.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).build()).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))}).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).setMoreResults(false).build());
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class ScanOpenNextThenExceptionThenRecoverConnection
    extends HConnectionManager.HConnectionImplementation {
        final ClientProtos.ClientService.BlockingInterface stub = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);

        ScanOpenNextThenExceptionThenRecoverConnection(Configuration conf, boolean managed, ExecutorService pool) throws IOException {
            super(conf, managed);
            long sid = 12345L;
            try {
                Mockito.when((Object)this.stub.scan((RpcController)Mockito.any(), (ClientProtos.ScanRequest)Mockito.any())).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).build()).thenThrow(new Throwable[]{new ServiceException((Throwable)new RegionServerStoppedException("From Mockito"))}).thenReturn((Object)ClientProtos.ScanResponse.newBuilder().setScannerId(sid).setMoreResults(false).build());
            }
            catch (ServiceException e) {
                throw new IOException(e);
            }
        }

        public ClientProtos.ClientService.BlockingInterface getClient(ServerName sn) throws IOException {
            return this.stub;
        }
    }

    static class SimpleRegistry
    implements Registry {
        final ServerName META_HOST = META_SERVERNAME;

        SimpleRegistry() {
        }

        public void init(HConnection connection) {
        }

        public HRegionLocation getMetaRegionLocation() throws IOException {
            return new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, this.META_HOST);
        }

        public String getClusterId() {
            return "default-cluster";
        }

        public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
            return enabled;
        }

        public int getCurrentNrHRS() throws IOException {
            return 1;
        }
    }
}

