/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RegionLoad {
    protected ClusterStatusProtos.RegionLoad regionLoadPB;

    public RegionLoad(ClusterStatusProtos.RegionLoad regionLoadPB) {
        this.regionLoadPB = regionLoadPB;
    }

    public byte[] getName() {
        return this.regionLoadPB.getRegionSpecifier().getValue().toByteArray();
    }

    public String getNameAsString() {
        return Bytes.toString((byte[])this.getName());
    }

    public int getStores() {
        return this.regionLoadPB.getStores();
    }

    public int getStorefiles() {
        return this.regionLoadPB.getStorefiles();
    }

    public int getStorefileSizeMB() {
        return this.regionLoadPB.getStorefileSizeMB();
    }

    public int getMemStoreSizeMB() {
        return this.regionLoadPB.getMemstoreSizeMB();
    }

    public int getStorefileIndexSizeMB() {
        return this.regionLoadPB.getStorefileIndexSizeMB();
    }

    public long getRequestsCount() {
        return this.getReadRequestsCount() + this.getWriteRequestsCount();
    }

    public long getReadRequestsCount() {
        return this.regionLoadPB.getReadRequestsCount();
    }

    public long getWriteRequestsCount() {
        return this.regionLoadPB.getWriteRequestsCount();
    }

    public int getRootIndexSizeKB() {
        return this.regionLoadPB.getRootIndexSizeKB();
    }

    public int getTotalStaticIndexSizeKB() {
        return this.regionLoadPB.getTotalStaticIndexSizeKB();
    }

    public int getTotalStaticBloomSizeKB() {
        return this.regionLoadPB.getTotalStaticBloomSizeKB();
    }

    public long getTotalCompactingKVs() {
        return this.regionLoadPB.getTotalCompactingKVs();
    }

    public long getCurrentCompactedKVs() {
        return this.regionLoadPB.getCurrentCompactedKVs();
    }

    public long getCompleteSequenceId() {
        return this.regionLoadPB.getCompleteSequenceId();
    }

    public int getStoreUncompressedSizeMB() {
        return this.regionLoadPB.getStoreUncompressedSizeMB();
    }

    public String toString() {
        StringBuilder sb = Strings.appendKeyValue((StringBuilder)new StringBuilder(), (String)"numberOfStores", (Object)this.getStores());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfStorefiles", (Object)this.getStorefiles());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileUncompressedSizeMB", (Object)this.getStoreUncompressedSizeMB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileSizeMB", (Object)this.getStorefileSizeMB());
        if (this.getStoreUncompressedSizeMB() != 0) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"compressionRatio", (Object)String.format("%.4f", Float.valueOf((float)this.getStorefileSizeMB() / (float)this.getStoreUncompressedSizeMB())));
        }
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"memstoreSizeMB", (Object)this.getMemStoreSizeMB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileIndexSizeMB", (Object)this.getStorefileIndexSizeMB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"readRequestsCount", (Object)this.getReadRequestsCount());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"writeRequestsCount", (Object)this.getWriteRequestsCount());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"rootIndexSizeKB", (Object)this.getRootIndexSizeKB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticIndexSizeKB", (Object)this.getTotalStaticIndexSizeKB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticBloomSizeKB", (Object)this.getTotalStaticBloomSizeKB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalCompactingKVs", (Object)this.getTotalCompactingKVs());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"currentCompactedKVs", (Object)this.getCurrentCompactedKVs());
        float compactionProgressPct = Float.NaN;
        if (this.getTotalCompactingKVs() > 0L) {
            compactionProgressPct = (float)this.getCurrentCompactedKVs() / (float)this.getTotalCompactingKVs();
        }
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"compactionProgressPct", (Object)Float.valueOf(compactionProgressPct));
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"completeSequenceId", (Object)this.getCompleteSequenceId());
        return sb.toString();
    }
}

