/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.client.mapr.AbstractHBaseAdmin;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.GenericHFactory;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.MasterCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MapRUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HBaseAdmin
implements Abortable,
Closeable {
    public static final String HBASE_ADMIN_CONNECT_AT_CONSTRUCTION = "hbase.admin.connect.at.construction";
    private static final GenericHFactory<AbstractHBaseAdmin> adminFactory_ = new GenericHFactory();
    private static final AtomicBoolean balancer_ = new AtomicBoolean();
    private volatile boolean connected_ = false;
    private volatile boolean isHbaseAvailable_ = true;
    private volatile AbstractHBaseAdmin maprHBaseAdmin_ = null;
    private volatile Throwable hbaseException_ = null;
    private BaseTableMappingRules tableMappingRule_;
    private final HBaseConnector hbaseConnector_;
    private static final Log LOG = LogFactory.getLog(HBaseAdmin.class);
    private HConnection connection;
    private volatile Configuration conf;
    private long pause;
    private int numRetries;
    private int retryLongerMultiplier;
    private boolean aborted;
    private boolean cleanupConnectionOnClose = false;
    private boolean closed = false;
    private RpcRetryingCallerFactory rpcCallerFactory;

    public HBaseAdmin(final Configuration c) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
                HBaseAdmin.this.connectWithConfiguration(c);
            }
        };
        this.commonInit(c);
    }

    void connectWithConfiguration(Configuration c) throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
        this.conf = new Configuration(c);
        this.connection = HConnectionManager.getConnection(this.conf);
        this.cleanupConnectionOnClose = true;
        this.pause = this.conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.numRetries = this.conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(this.conf);
    }

    public HBaseAdmin(final HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.hbaseConnector_ = new HBaseConnector(){

            @Override
            void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException {
                HBaseAdmin.this.connectWithHConnection(connection);
            }
        };
        this.commonInit(connection.getConfiguration());
        if (this.maprHBaseAdmin_ != null && connection instanceof HConnectionManager.HConnectionImplementation) {
            this.maprHBaseAdmin_.setUser(((HConnectionManager.HConnectionImplementation)connection).getUser());
        }
    }

    private void connectWithHConnection(HConnection connection) throws MasterNotRunningException, ZooKeeperConnectionException {
        this.conf = connection.getConfiguration();
        this.connection = connection;
        this.pause = this.conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.numRetries = this.conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.retryLongerMultiplier = this.conf.getInt("hbase.client.retries.longer.multiplier", 10);
        this.rpcCallerFactory = RpcRetryingCallerFactory.instantiate(this.conf);
    }

    private synchronized boolean ensureConnectedToHBase() throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.ensureConnectedToHBase(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean ensureConnectedToHBase(boolean throwException) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (!this.connected_) {
            if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                if (throwException) {
                    throw new MasterNotRunningException("This client is configured as MapR only.");
                }
                return false;
            }
            if (this.isHbaseAvailable_) {
                try {
                    this.hbaseConnector_.connect();
                    this.connected_ = true;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    this.hbaseException_ = e;
                }
                finally {
                    this.isHbaseAvailable_ = this.connected_;
                }
            }
            if (throwException) {
                if (this.hbaseException_ instanceof RuntimeException) {
                    throw (RuntimeException)this.hbaseException_;
                }
                if (this.hbaseException_ instanceof ZooKeeperConnectionException) {
                    throw (ZooKeeperConnectionException)this.hbaseException_;
                }
                if (!(this.hbaseException_ instanceof MasterNotRunningException)) {
                    this.hbaseException_ = new MasterNotRunningException().initCause(this.hbaseException_);
                }
                throw (MasterNotRunningException)this.hbaseException_;
            }
            return false;
        }
        return true;
    }

    private boolean checkIfMapRDefault(boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRDefault()) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(TableName tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRTable(tableName)) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(String tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        if (this.tableMappingRule_.isMapRTable(HRegionInfo.getTableName(tableName))) {
            return true;
        }
        if (connectToHBaseOtherwise) {
            this.ensureConnectedToHBase();
        }
        return false;
    }

    private boolean checkIfMapRTable(byte[] tableName, boolean connectToHBaseOtherwise) throws ZooKeeperConnectionException, MasterNotRunningException {
        return this.checkIfMapRTable(Bytes.toString((byte[])tableName), connectToHBaseOtherwise);
    }

    private void commonInit(Configuration c) throws ZooKeeperConnectionException, MasterNotRunningException {
        this.conf = c;
        if (BaseTableMappingRules.isInHBaseService()) {
            this.tableMappingRule_ = BaseTableMappingRules.INSTANCE;
        } else {
            try {
                this.tableMappingRule_ = TableMappingRulesFactory.create(this.conf);
                if (this.tableMappingRule_.getClusterType() != BaseTableMappingRules.ClusterType.HBASE_ONLY) {
                    this.maprHBaseAdmin_ = adminFactory_.getImplementorInstance(this.conf.get("hbaseadmin.impl.mapr", "com.mapr.fs.hbase.HBaseAdminImpl"), new Object[]{this.conf, this.tableMappingRule_}, Configuration.class, BaseTableMappingRules.class);
                }
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
        }
        if (this.tableMappingRule_.getClusterType() == BaseTableMappingRules.ClusterType.HBASE_ONLY || c.getBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, false)) {
            this.ensureConnectedToHBase();
        }
    }

    private synchronized CatalogTracker getCatalogTracker() throws ZooKeeperConnectionException, IOException {
        CatalogTracker ct = null;
        try {
            ct = new CatalogTracker(this.conf);
            ct.start();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
        }
        return ct;
    }

    private void cleanupCatalogTracker(CatalogTracker ct) {
        ct.stop();
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    public HConnection getConnection() {
        try {
            this.ensureConnectedToHBase();
        }
        catch (IOException e) {
            this.connection = null;
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        int numRetries = this.conf.getInt("hbase.client.retries.number", 10);
        try {
            this.conf.setInt("hbase.client.retries.number", this.conf.getInt("hbase.client.retries.number.alternate", 1));
            this.ensureConnectedToHBase();
        }
        finally {
            this.conf.setInt("hbase.client.retries.number", numRetries);
            this.numRetries = numRetries;
        }
        return this.connection.isMasterRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.tableExists(tableName.getAliasAsString());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        boolean b = false;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            b = MetaReader.tableExists(ct, tableName);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return b;
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf((byte[])tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables();
        }
        return this.connection.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tables;
        String regex = pattern.pattern();
        if (this.checkIfMapRTable(regex, false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTables(regex);
        }
        if (!(regex = MapRUtil.adjustTableNameString((String)regex)).equals(pattern.pattern())) {
            pattern = Pattern.compile(regex);
        }
        LinkedList<HTableDescriptor> matched = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : tables = this.listTables()) {
            if (!pattern.matcher(table.getTableName().getNameAsString()).matches()) continue;
            matched.add(table);
        }
        return matched.toArray(new HTableDescriptor[matched.size()]);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    @Deprecated
    public String[] getTableNames() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.getTableNames();
        }
        return this.connection.getTableNames();
    }

    @Deprecated
    public String[] getTableNames(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.getTableNames(pattern.pattern());
        }
        ArrayList<String> matched = new ArrayList<String>();
        for (String name : this.connection.getTableNames()) {
            if (!pattern.matcher(name).matches()) continue;
            matched.add(name);
        }
        return matched.toArray(new String[matched.size()]);
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        if (this.checkIfMapRTable(regex, true)) {
            return this.maprHBaseAdmin_.getTableNames(regex);
        }
        return this.getTableNames(Pattern.compile(regex));
    }

    public TableName[] listTableNames() throws IOException {
        if (this.checkIfMapRDefault(false) || !this.ensureConnectedToHBase(false)) {
            return this.maprHBaseAdmin_.listTableNames();
        }
        return this.connection.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableDescriptor(tableName.getAliasAsString());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return this.connection.getHTableDescriptor(tableName);
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        return this.getTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(final HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        try {
            this.createTableAsync(desc, splitKeys);
            if (this.checkIfMapRTable(desc.getTableName(), false)) {
                return;
            }
        }
        catch (SocketTimeoutException ste) {
            LOG.warn((Object)("Creating " + desc.getTableName() + " took too long"), (Throwable)ste);
        }
        int numRegs = splitKeys == null ? 1 : splitKeys.length + 1;
        int prevRegCount = 0;
        boolean doneWithMetaScan = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            if (!doneWithMetaScan) {
                final AtomicInteger actualRegCount = new AtomicInteger(0);
                MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                    @Override
                    public boolean processRow(Result rowResult) throws IOException {
                        HRegionInfo info = HRegionInfo.getHRegionInfo(rowResult);
                        if (info == null) {
                            LOG.warn((Object)("No serialized HRegionInfo in " + rowResult));
                            return true;
                        }
                        if (!info.getTable().equals((Object)desc.getTableName())) {
                            return false;
                        }
                        ServerName serverName = HRegionInfo.getServerName(rowResult);
                        if (!info.isOffline() && !info.isSplit() && serverName != null && serverName.getHostAndPort() != null) {
                            actualRegCount.incrementAndGet();
                        }
                        return true;
                    }
                };
                MetaScanner.metaScan(this.conf, this.connection, visitor, desc.getTableName());
                if (actualRegCount.get() < numRegs) {
                    if (tries == this.numRetries * this.retryLongerMultiplier - 1) {
                        throw new RegionOfflineException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
                    }
                    try {
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                    }
                    if (actualRegCount.get() <= prevRegCount) continue;
                    prevRegCount = actualRegCount.get();
                    tries = -1;
                    continue;
                }
                doneWithMetaScan = true;
                tries = -1;
                continue;
            }
            if (this.isTableEnabled(desc.getTableName())) {
                return;
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted when waiting for table to be enabled; meta scan was done");
            }
        }
        throw new TableNotEnabledException("Retries exhausted while still waiting for table: " + desc.getTableName() + " to be enabled");
    }

    public void createTableAsync(final HTableDescriptor desc, final byte[][] splitKeys) throws IOException {
        desc.validate();
        if (this.checkIfMapRTable(desc.getTableName(), true)) {
            this.maprHBaseAdmin_.createTable(desc, splitKeys);
            return;
        }
        TableName.isLegalFullyQualifiedTableName((byte[])desc.getTableName().getName());
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo((byte[])splitKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals((byte[])splitKey, (byte[])lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary((byte[])splitKey) + ", " + Bytes.toStringBinary((byte[])lastKey));
                }
                lastKey = splitKey;
            }
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.CreateTableRequest request = RequestConverter.buildCreateTableRequest(desc, splitKeys);
                this.master.createTable(null, request);
                return null;
            }
        });
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    public void deleteTable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.deleteTableInternal(tableName);
    }

    private void deleteTableInternal(final TableName tableName) throws IOException {
        boolean tableExists = true;
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.DeleteTableRequest req = RequestConverter.buildDeleteTableRequest(tableName);
                this.master.deleteTable(null, req);
                return null;
            }
        });
        int failures = 0;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            block15: {
                try {
                    MasterProtos.GetTableDescriptorsResponse htds;
                    HRegionLocation firstMetaServer = this.getFirstMetaServerForTable(tableName);
                    Scan scan = MetaReader.getScanForTableName(tableName);
                    scan.addColumn(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(firstMetaServer.getRegionInfo().getRegionName(), scan, 1, true);
                    Result[] values = null;
                    ClientProtos.ClientService.BlockingInterface server = this.connection.getClient(firstMetaServer.getServerName());
                    PayloadCarryingRpcController controller = new PayloadCarryingRpcController();
                    try {
                        controller.setPriority(tableName);
                        ClientProtos.ScanResponse response = server.scan((RpcController)controller, request);
                        values = ResponseConverter.getResults(controller.cellScanner(), response);
                    }
                    catch (ServiceException se) {
                        throw ProtobufUtil.getRemoteException(se);
                    }
                    if (values != null && values.length != 0) break block15;
                    tableExists = false;
                    MasterKeepAliveConnection master = this.connection.getKeepAliveMasterService();
                    try {
                        MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                        htds = master.getTableDescriptors(null, req);
                    }
                    catch (ServiceException se) {
                        throw ProtobufUtil.getRemoteException(se);
                    }
                    finally {
                        master.close();
                    }
                    boolean bl = tableExists = !htds.getTableSchemaList().isEmpty();
                    if (!tableExists) {
                        break;
                    }
                }
                catch (IOException ex) {
                    if (++failures != this.numRetries - 1) break block15;
                    if (ex instanceof RemoteException) {
                        throw ((RemoteException)((Object)ex)).unwrapRemoteException();
                    }
                    throw ex;
                }
            }
            try {
                Thread.sleep(this.getPauseTime(tries));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (tableExists) {
            throw new IOException("Retries exhausted, it took too long to wait for the table " + tableName + " to be deleted.");
        }
        this.connection.clearRegionCache(tableName);
        LOG.info((Object)("Deleted " + tableName));
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.deleteTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to delete table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.enableTableAsync(tableName);
        this.waitUntilTableIsEnabled(tableName);
        LOG.info((Object)("Enabled table " + tableName));
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    private void waitUntilTableIsEnabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return;
        }
        boolean enabled = false;
        long start = EnvironmentEdgeManager.currentTimeMillis();
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier; ++tries) {
            try {
                enabled = this.isTableEnabled(tableName);
            }
            catch (TableNotFoundException tnfe) {
                enabled = false;
            }
            boolean bl = enabled = enabled && this.isTableAvailable(tableName);
            if (enabled) break;
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "enabled in " + tableName));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
        }
        if (!enabled) {
            long msec = EnvironmentEdgeManager.currentTimeMillis() - start;
            throw new IOException("Table '" + tableName + "' not yet enabled, after " + msec + "ms.");
        }
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.enableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.enableTableAsyncInternal(tableName);
    }

    private void enableTableAsyncInternal(final TableName tableName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                LOG.info((Object)("Started enable of " + tableName));
                MasterProtos.EnableTableRequest req = RequestConverter.buildEnableTableRequest(tableName);
                this.master.enableTable(null, req);
                return null;
            }
        });
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTableAsync(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.enableTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to enable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(tableName.getAliasAsString());
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.disableTableAsyncInternal(tableName);
    }

    private void disableTableAsyncInternal(final TableName tableName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                LOG.info((Object)("Started disable of " + tableName));
                MasterProtos.DisableTableRequest req = RequestConverter.buildDisableTableRequest(tableName);
                this.master.disableTable(null, req);
                return null;
            }
        });
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf((byte[])tableName));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTableAsync(TableName.valueOf((String)tableName));
    }

    public void disableTable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.disableTable(tableName.getAliasAsString());
            return;
        }
        this.disableTableAsync(tableName);
        boolean disabled = false;
        for (int tries = 0; tries < this.numRetries * this.retryLongerMultiplier && !(disabled = this.isTableDisabled(tableName)); ++tries) {
            long sleep = this.getPauseTime(tries);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Sleeping= " + sleep + "ms, waiting for all regions to be " + "disabled in " + tableName));
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
        }
        if (!disabled) {
            throw new RegionException("Retries exhausted, it took too long to wait for the table " + tableName + " to be disabled.");
        }
        LOG.info((Object)("Disabled " + tableName));
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        if (this.checkIfMapRTable(pattern.pattern(), true)) {
            return this.maprHBaseAdmin_.disableTables(pattern.pattern());
        }
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info((Object)("Failed to disable table " + table.getTableName()), (Throwable)ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    private void checkTableExistence(TableName tableName) throws IOException {
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableEnabled(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        this.checkTableExistence(tableName);
        return this.connection.isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableDisabled(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        this.checkTableExistence(tableName);
        return this.connection.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString());
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return this.connection.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.isTableAvailable(tableName.getAliasAsString(), splitKeys);
        }
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        return this.connection.isTableAvailable(tableName, splitKeys);
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName), splitKeys);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return new Pair((Object)0, (Object)0);
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        return this.getAlterStatusInternal(tableName);
    }

    private Pair<Integer, Integer> getAlterStatusInternal(final TableName tableName) throws IOException {
        return this.executeCallable(new MasterCallable<Pair<Integer, Integer>>(this.getConnection()){

            @Override
            public Pair<Integer, Integer> call() throws ServiceException {
                MasterProtos.GetSchemaAlterStatusRequest req = RequestConverter.buildGetSchemaAlterStatusRequest(tableName);
                MasterProtos.GetSchemaAlterStatusResponse ret = this.master.getSchemaAlterStatus(null, req);
                Pair pair = new Pair((Object)ret.getYetToUpdateRegions(), (Object)ret.getTotalRegions());
                return pair;
            }
        });
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((byte[])tableName));
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((byte[])tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        column.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.addColumn(tableName.getAliasAsString(), column);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.addColumnInternal(tableName, column);
    }

    private void addColumnInternal(final TableName tableName, final HColumnDescriptor column) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.AddColumnRequest req = RequestConverter.buildAddColumnRequest(tableName, column);
                this.master.addColumn(null, req);
                return null;
            }
        });
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((byte[])tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.deleteColumn(tableName.getAliasAsString(), Bytes.toString((byte[])columnName));
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.deleteColumnInternal(tableName, columnName);
    }

    private void deleteColumnInternal(final TableName tableName, final byte[] columnName) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.DeleteColumnRequest req = RequestConverter.buildDeleteColumnRequest(tableName, columnName);
                this.master.deleteColumn(null, req);
                return null;
            }
        });
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((byte[])tableName), descriptor);
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor descriptor) throws IOException {
        descriptor.validate();
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyColumn(tableName.getAliasAsString(), descriptor);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.modifyColumnInternal(tableName, descriptor);
    }

    private void modifyColumnInternal(final TableName tableName, final HColumnDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.ModifyColumnRequest req = RequestConverter.buildModifyColumnRequest(tableName, descriptor);
                this.master.modifyColumn(null, req);
                return null;
            }
        });
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        this.closeRegion(Bytes.toBytes((String)regionname), serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        if (this.checkIfMapRTable(regionname, true)) {
            this.maprHBaseAdmin_.closeRegion(regionname, serverName);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        try {
            if (serverName != null) {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null || pair.getFirst() == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                this.closeRegion(ServerName.valueOf(serverName), (HRegionInfo)pair.getFirst());
            } else {
                Pair<HRegionInfo, ServerName> pair = MetaReader.getRegion(ct, regionname);
                if (pair == null) {
                    throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                if (pair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])regionname));
                }
                this.closeRegion((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst());
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        if (this.checkIfMapRTable(encodedRegionName, true)) {
            this.maprHBaseAdmin_.closeRegionWithEncodedRegionName(encodedRegionName, serverName);
            return true;
        }
        if (null == serverName || "".equals(serverName.trim())) {
            throw new IllegalArgumentException("The servername cannot be null or empty.");
        }
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CloseRegionRequest request = RequestConverter.buildCloseRegionRequest(sn, encodedRegionName, false);
        try {
            AdminProtos.CloseRegionResponse response = admin.closeRegion(null, request);
            boolean isRegionClosed = response.getClosed();
            if (!isRegionClosed) {
                LOG.error((Object)("Not able to close the region " + encodedRegionName + "."));
            }
            return isRegionClosed;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        if (this.checkIfMapRTable(hri.getRegionName(), true)) {
            this.maprHBaseAdmin_.closeRegion(sn, hri);
            return;
        }
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.closeRegion(admin, sn, hri.getRegionName(), false);
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            throw new UnsupportedOperationException("getOnlineRegions is not supported for MapR.");
        }
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        return ProtobufUtil.getOnlineRegions(admin);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.flush(tableNameOrRegionName);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = MapRUtil.adjustTableName((byte[])tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.flush((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst());
            } else {
                TableName tableName = this.checkTableExists(TableName.valueOf((byte[])tableNameOrRegionName), ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.flush((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst());
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Trying to flush " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void flush(ServerName sn, HRegionInfo hri) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(hri.getRegionName());
        try {
            admin.flushRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public void compact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, false);
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, false);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, null, true);
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException, InterruptedException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException, InterruptedException {
        this.compact(tableNameOrRegionName, columnFamily, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(byte[] tableNameOrRegionName, byte[] columnFamily, boolean major) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.compact(tableNameOrRegionName, columnFamily, major);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = MapRUtil.adjustTableName((byte[])tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.compact((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), major, columnFamily);
            } else {
                TableName tableName = this.checkTableExists(TableName.valueOf((byte[])tableNameOrRegionName), ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                    try {
                        this.compact((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), major, columnFamily);
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Trying to" + (major ? " major" : "") + " compact " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        if (this.checkIfMapRTable(hri.getRegionName(), true)) {
            this.maprHBaseAdmin_.compact(sn, hri, major, family);
            return;
        }
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family);
        try {
            admin.compactRegion(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRTable(encodedRegionName, true)) {
            this.maprHBaseAdmin_.move(encodedRegionName, destServerName);
            return;
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            MasterProtos.MoveRegionRequest request = RequestConverter.buildMoveRegionRequest(encodedRegionName, destServerName);
            stub.moveRegion(null, request);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)ioe;
            }
            LOG.error((Object)("Unexpected exception: " + (Object)((Object)se) + " from calling HMaster.moveRegion"));
        }
        catch (DeserializationException de) {
            LOG.error((Object)("Could not parse destination server name: " + de));
        }
        finally {
            stub.close();
        }
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(regionName, true)) {
            this.maprHBaseAdmin_.assign(regionName);
            return;
        }
        final byte[] toBeAssigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.AssignRegionRequest request = RequestConverter.buildAssignRegionRequest(toBeAssigned);
                this.master.assignRegion(null, request);
                return null;
            }
        });
    }

    public void unassign(byte[] regionName, final boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        if (this.checkIfMapRTable(regionName, true)) {
            this.maprHBaseAdmin_.unassign(regionName, force);
            return;
        }
        final byte[] toBeUnassigned = this.getRegionName(regionName);
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.UnassignRegionRequest request = RequestConverter.buildUnassignRegionRequest(toBeUnassigned, force);
                this.master.unassignRegion(null, request);
                return null;
            }
        });
    }

    public void offline(byte[] regionName) throws IOException, ZooKeeperConnectionException {
        if (this.checkIfMapRTable(regionName, true)) {
            this.maprHBaseAdmin_.offline(regionName);
            return;
        }
        MasterKeepAliveConnection master = this.connection.getKeepAliveMasterService();
        try {
            master.offlineRegion(null, RequestConverter.buildOfflineRegionRequest(regionName));
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        finally {
            master.close();
        }
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return balancer_.getAndSet(on);
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            MasterProtos.SetBalancerRunningRequest req = RequestConverter.buildSetBalancerRunningRequest(on, synchronous);
            boolean bl = stub.setBalancerRunning(null, req).getPrevBalanceValue();
            return bl;
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof MasterNotRunningException) {
                throw (MasterNotRunningException)ioe;
            }
            if (ioe instanceof ZooKeeperConnectionException) {
                throw (ZooKeeperConnectionException)ioe;
            }
            throw new MasterNotRunningException("Unexpected exception when calling balanceSwitch", (Exception)((Object)se));
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException {
        if (this.checkIfMapRDefault(true)) {
            return true;
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            boolean bl = stub.balance(null, RequestConverter.buildBalanceRequest()).getBalancerRan();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableCatalogJanitor(boolean enable) throws ServiceException, MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.enableCatalogJanitor(enable);
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            boolean bl = stub.enableCatalogJanitor(null, RequestConverter.buildEnableCatalogJanitorRequest(enable)).getPrevValue();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runCatalogScan() throws ServiceException, MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.runCatalogScan();
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            int n = stub.runCatalogScan(null, RequestConverter.buildCatalogScanRequest()).getScanResult();
            return n;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCatalogJanitorEnabled() throws ServiceException, MasterNotRunningException, ZooKeeperConnectionException {
        if (this.checkIfMapRDefault(true)) {
            return this.maprHBaseAdmin_.isCatalogJanitorEnabled();
        }
        MasterKeepAliveConnection stub = this.connection.getKeepAliveMasterService();
        try {
            boolean bl = stub.isCatalogJanitorEnabled(null, RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue();
            return bl;
        }
        finally {
            stub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        MasterKeepAliveConnection master = this.connection.getKeepAliveMasterService();
        try {
            MasterProtos.DispatchMergingRegionsRequest request = RequestConverter.buildDispatchMergingRegionsRequest(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
            master.dispatchMergingRegions(null, request);
        }
        catch (ServiceException se) {
            IOException ioe = ProtobufUtil.getRemoteException(se);
            if (ioe instanceof UnknownRegionException) {
                throw (UnknownRegionException)((Object)ioe);
            }
            if (ioe instanceof MergeRegionException) {
                throw (MergeRegionException)((Object)ioe);
            }
            LOG.error((Object)("Unexpected exception: " + (Object)((Object)se) + " from calling HMaster.dispatchMergingRegions"));
        }
        catch (DeserializationException de) {
            LOG.error((Object)("Could not parse destination server name: " + de));
        }
        finally {
            master.close();
        }
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        this.split(tableNameOrRegionName, null);
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException, InterruptedException {
        this.split(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)splitPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            this.maprHBaseAdmin_.split(tableNameOrRegionName, splitPoint);
            return;
        }
        CatalogTracker ct = this.getCatalogTracker();
        tableNameOrRegionName = MapRUtil.adjustTableName((byte[])tableNameOrRegionName);
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                this.split((ServerName)regionServerPair.getSecond(), (HRegionInfo)regionServerPair.getFirst(), splitPoint);
            } else {
                TableName tableName = this.checkTableExists(TableName.valueOf((byte[])tableNameOrRegionName), ct);
                List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
                for (Pair<HRegionInfo, ServerName> pair : pairs) {
                    HRegionInfo r;
                    if (pair.getSecond() == null || (r = (HRegionInfo)pair.getFirst()).isSplitParent() || splitPoint != null && !r.containsRow(splitPoint)) continue;
                    this.split((ServerName)pair.getSecond(), (HRegionInfo)pair.getFirst(), splitPoint);
                }
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    private void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        if (hri.getStartKey() != null && splitPoint != null && Bytes.compareTo((byte[])hri.getStartKey(), (byte[])splitPoint) == 0) {
            throw new IOException("should not give a splitkey which equals to startkey!");
        }
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        ProtobufUtil.split(admin, hri, splitPoint);
    }

    public void modifyTable(TableName tableName, HTableDescriptor htd) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            this.maprHBaseAdmin_.modifyTable(tableName.getAliasAsString(), htd);
            return;
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        this.modifyTableInternal(tableName, htd);
    }

    private void modifyTableInternal(final TableName tableName, final HTableDescriptor htd) throws IOException {
        if (!tableName.equals((Object)htd.getTableName())) {
            throw new IllegalArgumentException("the specified table name '" + tableName + "' doesn't match with the HTD one: " + htd.getTableName());
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                MasterProtos.ModifyTableRequest request = RequestConverter.buildModifyTableRequest(tableName, htd);
                this.master.modifyTable(null, request);
                return null;
            }
        });
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    Pair<HRegionInfo, ServerName> getRegion(byte[] tableNameOrRegionName, CatalogTracker ct) throws IOException {
        if (tableNameOrRegionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaReader.getRegion(ct, tableNameOrRegionName);
        if (pair == null) {
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            final String encodedName = Bytes.toString((byte[])tableNameOrRegionName);
            MetaScanner.MetaScannerVisitorBase visitor = new MetaScanner.MetaScannerVisitorBase(){

                @Override
                public boolean processRow(Result data) throws IOException {
                    HRegionInfo info = HRegionInfo.getHRegionInfo(data);
                    if (info == null) {
                        LOG.warn((Object)("No serialized HRegionInfo in " + data));
                        return true;
                    }
                    if (!encodedName.equals(info.getEncodedName())) {
                        return true;
                    }
                    ServerName sn = HRegionInfo.getServerName(data);
                    result.set(new Pair((Object)info, (Object)sn));
                    return false;
                }
            };
            MetaScanner.metaScan(this.conf, this.connection, visitor, null);
            pair = result.get();
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getRegionName(byte[] regionNameOrEncodedRegionName) throws IOException {
        if (Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals((byte[])regionNameOrEncodedRegionName, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            return HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
        }
        CatalogTracker ct = this.getCatalogTracker();
        byte[] tmp = regionNameOrEncodedRegionName;
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(regionNameOrEncodedRegionName, ct);
            if (regionServerPair != null && regionServerPair.getFirst() != null) {
                tmp = ((HRegionInfo)regionServerPair.getFirst()).getRegionName();
            }
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return tmp;
    }

    private TableName checkTableExists(TableName tableName, CatalogTracker ct) throws IOException {
        if (!MetaReader.tableExists(ct, tableName)) {
            throw new TableNotFoundException(tableName);
        }
        return tableName;
    }

    public synchronized void shutdown() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            LOG.warn((Object)"shutdown() called for a MapR cluster, silently ignoring.");
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                this.master.shutdown(null, MasterProtos.ShutdownRequest.newBuilder().build());
                return null;
            }
        });
    }

    public synchronized void stopMaster() throws IOException {
        if (this.checkIfMapRDefault(true)) {
            LOG.warn((Object)"stopMaster() called for a MapR cluster, silently ignoring.");
            return;
        }
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                this.master.stopMaster(null, MasterProtos.StopMasterRequest.newBuilder().build());
                return null;
            }
        });
    }

    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        if (this.checkIfMapRDefault(true)) {
            LOG.warn((Object)"stopRegionServer() called for a MapR cluster, silently ignoring.");
            return;
        }
        String hostname = Addressing.parseHostname((String)hostnamePort);
        int port = Addressing.parsePort((String)hostnamePort);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(ServerName.valueOf(hostname, port, 0L));
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.connection.toString());
        try {
            admin.stopServer(null, request);
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        if (!this.ensureConnectedToHBase(false)) {
            return null;
        }
        return this.executeCallable(new MasterCallable<ClusterStatus>(this.getConnection()){

            @Override
            public ClusterStatus call() throws ServiceException {
                MasterProtos.GetClusterStatusRequest req = RequestConverter.buildGetClusterStatusRequest();
                return ClusterStatus.convert(this.master.getClusterStatus(null, req).getClusterStatus());
            }
        });
    }

    private HRegionLocation getFirstMetaServerForTable(TableName tableName) throws IOException {
        return this.connection.locateRegion(TableName.META_TABLE_NAME, HRegionInfo.createRegionName(tableName, null, "99999999999999", false));
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public void createNamespace(final NamespaceDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws Exception {
                this.master.createNamespace(null, MasterProtos.CreateNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    public void modifyNamespace(final NamespaceDescriptor descriptor) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws Exception {
                this.master.modifyNamespace(null, MasterProtos.ModifyNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
                return null;
            }
        });
    }

    public void deleteNamespace(final String name) throws IOException {
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws Exception {
                this.master.deleteNamespace(null, MasterProtos.DeleteNamespaceRequest.newBuilder().setNamespaceName(name).build());
                return null;
            }
        });
    }

    public NamespaceDescriptor getNamespaceDescriptor(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<NamespaceDescriptor>(this.getConnection()){

            @Override
            public NamespaceDescriptor call() throws Exception {
                return ProtobufUtil.toNamespaceDescriptor(this.master.getNamespaceDescriptor(null, MasterProtos.GetNamespaceDescriptorRequest.newBuilder().setNamespaceName(name).build()).getNamespaceDescriptor());
            }
        });
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.executeCallable(new MasterCallable<NamespaceDescriptor[]>(this.getConnection()){

            @Override
            public NamespaceDescriptor[] call() throws Exception {
                List list = this.master.listNamespaceDescriptors(null, MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build()).getNamespaceDescriptorList();
                NamespaceDescriptor[] res = new NamespaceDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)list.get(i));
                }
                return res;
            }
        });
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<HTableDescriptor[]>(this.getConnection()){

            @Override
            public HTableDescriptor[] call() throws Exception {
                List list = this.master.listTableDescriptorsByNamespace(null, MasterProtos.ListTableDescriptorsByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableSchemaList();
                HTableDescriptor[] res = new HTableDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = HTableDescriptor.convert((HBaseProtos.TableSchema)list.get(i));
                }
                return res;
            }
        });
    }

    public TableName[] listTableNamesByNamespace(final String name) throws IOException {
        return this.executeCallable(new MasterCallable<TableName[]>(this.getConnection()){

            @Override
            public TableName[] call() throws Exception {
                List tableNames = this.master.listTableNamesByNamespace(null, MasterProtos.ListTableNamesByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableNameList();
                TableName[] result = new TableName[tableNames.size()];
                for (int i = 0; i < tableNames.size(); ++i) {
                    result[i] = ProtobufUtil.toTableName((HBaseProtos.TableName)tableNames.get(i));
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkHBaseAvailable(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, ServiceException, IOException {
        try {
            if (TableMappingRulesFactory.create(conf).getClusterType() == BaseTableMappingRules.ClusterType.MAPR_ONLY) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Configuration copyOfConf = HBaseConfiguration.create((Configuration)conf);
        copyOfConf.setInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, 1);
        copyOfConf.setBoolean(HBASE_ADMIN_CONNECT_AT_CONSTRUCTION, true);
        copyOfConf.setInt("zookeeper.recovery.retry", 0);
        HConnectionManager.HConnectionImplementation connection = (HConnectionManager.HConnectionImplementation)HConnectionManager.getConnection(copyOfConf);
        try {
            ZooKeeperKeepAliveConnection zkw = null;
            try {
                zkw = connection.getKeepAliveZooKeeperWatcher();
                zkw.getRecoverableZooKeeper().getZooKeeper().exists(zkw.baseZNode, false);
            }
            catch (IOException e) {
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", e);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Can't connect to ZooKeeper").initCause(e);
            }
            catch (KeeperException e) {
                throw new ZooKeeperConnectionException("Can't connect to ZooKeeper", (Exception)((Object)e));
            }
            finally {
                if (zkw != null) {
                    zkw.close();
                }
            }
            connection.isMasterRunning();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        if (this.checkIfMapRTable(tableName, true)) {
            return this.maprHBaseAdmin_.getTableRegions(tableName.getQualifier());
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        CatalogTracker ct = this.getCatalogTracker();
        List<HRegionInfo> Regions = null;
        try {
            Regions = MetaReader.getTableRegions(ct, tableName, true);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
        return Regions;
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        return this.getTableRegions(TableName.valueOf((byte[])tableName));
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.cleanupConnectionOnClose && this.connection != null && !this.closed) {
            this.connection.close();
            this.closed = true;
        }
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        ArrayList<HTableDescriptor> list = new ArrayList<HTableDescriptor>();
        for (TableName tableName : tableNames) {
            list.add(this.getTableDescriptor(tableName));
        }
        return list.toArray(new HTableDescriptor[list.size()]);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
        for (String name : names) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        if (this.checkIfMapRDefault(true)) {
            LOG.warn((Object)"rollHLogWriter() called for a MapR cluster, returning null.");
            return null;
        }
        ServerName sn = ServerName.valueOf(serverName);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.RollWALWriterRequest request = RequestConverter.buildRollWALWriterRequest();
        try {
            AdminProtos.RollWALWriterResponse response = admin.rollWALWriter(null, request);
            int regionCount = response.getRegionToFlushCount();
            byte[][] regionsToFlush = new byte[regionCount][];
            for (int i = 0; i < regionCount; ++i) {
                ByteString region = response.getRegionToFlush(i);
                regionsToFlush[i] = region.toByteArray();
            }
            return regionsToFlush;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    public String[] getMasterCoprocessors() {
        try {
            if (this.checkIfMapRDefault(true)) {
                LOG.warn((Object)"getMasterCoprocessors() called for a MapR cluster, returning empty.");
                return new String[0];
            }
            return this.getClusterStatus().getMasterCoprocessors();
        }
        catch (IOException e) {
            LOG.error((Object)"Could not getClusterStatus()", (Throwable)e);
            return null;
        }
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        return this.getCompactionState(Bytes.toBytes((String)tableNameOrRegionName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        if (this.checkIfMapRTable(tableNameOrRegionName, true)) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        }
        tableNameOrRegionName = MapRUtil.adjustTableName((byte[])tableNameOrRegionName);
        AdminProtos.GetRegionInfoResponse.CompactionState state = AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        CatalogTracker ct = this.getCatalogTracker();
        try {
            Pair<HRegionInfo, ServerName> regionServerPair = this.getRegion(tableNameOrRegionName, ct);
            if (regionServerPair != null) {
                if (regionServerPair.getSecond() == null) {
                    throw new NoServerForRegionException(Bytes.toStringBinary((byte[])tableNameOrRegionName));
                }
                ServerName sn = (ServerName)regionServerPair.getSecond();
                AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
                AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)regionServerPair.getFirst()).getRegionName(), true);
                AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = response.getCompactionState();
                return compactionState;
            }
            TableName tableName = this.checkTableExists(TableName.valueOf((byte[])tableNameOrRegionName), ct);
            List<Pair<HRegionInfo, ServerName>> pairs = MetaReader.getTableRegionsAndLocations(ct, tableName);
            Iterator<Pair<HRegionInfo, ServerName>> i$ = pairs.iterator();
            while (i$.hasNext()) {
                Pair<HRegionInfo, ServerName> pair = i$.next();
                if (((HRegionInfo)pair.getFirst()).isOffline() || pair.getSecond() == null) continue;
                try {
                    ServerName sn = (ServerName)pair.getSecond();
                    AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
                    AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(((HRegionInfo)pair.getFirst()).getRegionName(), true);
                    AdminProtos.GetRegionInfoResponse response = admin.getRegionInfo(null, request);
                    switch (response.getCompactionState()) {
                        case MAJOR_AND_MINOR: {
                            AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                            return compactionState;
                        }
                        case MAJOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MINOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR;
                            break;
                        }
                        case MINOR: {
                            if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) {
                                AdminProtos.GetRegionInfoResponse.CompactionState compactionState = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
                                return compactionState;
                            }
                            state = AdminProtos.GetRegionInfoResponse.CompactionState.MINOR;
                            break;
                        }
                    }
                }
                catch (NotServingRegionException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
                catch (RemoteException e) {
                    if (e.getMessage().indexOf(NotServingRegionException.class.getName()) < 0) throw e;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Trying to get compaction state of " + pair.getFirst() + ": " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            return state;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
        finally {
            this.cleanupCatalogTracker(ct);
        }
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((String)tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), Bytes.toString((byte[])tableName), flushType);
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), tableName, HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotName), TableName.valueOf((byte[])tableName), HBaseProtos.SnapshotDescription.Type.FLUSH);
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        if (this.checkIfMapRTable(tableName, true)) {
            throw new IllegalArgumentException("snapshot() called for a MapR Table.");
        }
        tableName = MapRUtil.adjustTableName((TableName)tableName);
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        HBaseProtos.SnapshotDescription.Builder builder = HBaseProtos.SnapshotDescription.newBuilder();
        builder.setTable(tableName.getNameAsString());
        builder.setName(snapshotName);
        builder.setType(type);
        this.snapshot(builder.build());
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((String)tableName), type);
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, TableName.valueOf((byte[])tableName), type);
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        MasterProtos.SnapshotResponse response = this.takeSnapshotAsync(snapshot);
        final MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = null;
        long start = EnvironmentEdgeManager.currentTimeMillis();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString(snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        while (tries == 0 || EnvironmentEdgeManager.currentTimeMillis() - start < max && !done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " to complete"));
                Thread.currentThread().interrupt();
            }
            LOG.debug((Object)"Getting current status of snapshot from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsSnapshotDoneResponse call() throws ServiceException {
                    return this.master.isSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshot);
        }
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            throw new IllegalArgumentException("takeSnapshotAsync() called for a MapR Table.");
        }
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.executeCallable(new MasterCallable<MasterProtos.SnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.SnapshotResponse call() throws ServiceException {
                return this.master.snapshot(null, request);
            }
        });
    }

    public boolean isSnapshotFinished(final HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        if (this.checkIfMapRTable(snapshot.getTable(), true)) {
            throw new UnsupportedOperationException("isSnapshotFinished() called for a MapR Table.");
        }
        return this.executeCallable(new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsSnapshotDoneResponse call() throws ServiceException {
                return this.master.isSnapshotDone(null, MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build());
            }
        }).getDone();
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString((byte[])snapshotName));
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        boolean takeFailSafeSnapshot = this.conf.getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", false);
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString((byte[])snapshotName), takeFailSafeSnapshot);
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.ensureConnectedToHBase();
        TableName tableName = null;
        for (HBaseProtos.SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = TableName.valueOf((String)snapshotInfo.getTable());
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        if (this.checkIfMapRTable(tableName, true)) {
            throw new UnsupportedOperationException("restoreSnapshot called for a MapR Table.");
        }
        if (!this.tableExists(tableName)) {
            try {
                this.cloneSnapshot(snapshotName, tableName);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted when restoring a nonexistent table: " + e.getMessage());
            }
            return;
        }
        if (!this.isTableDisabled(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
        String failSafeSnapshotSnapshotName = null;
        if (takeFailSafeSnapshot) {
            failSafeSnapshotSnapshotName = this.conf.get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotName.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTimeMillis()));
            LOG.info((Object)("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
            this.snapshot(failSafeSnapshotSnapshotName, tableName);
        }
        try {
            this.internalRestoreSnapshot(snapshotName, tableName);
        }
        catch (IOException e) {
            if (takeFailSafeSnapshot) {
                try {
                    this.internalRestoreSnapshot(failSafeSnapshotSnapshotName, tableName);
                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                    LOG.error((Object)msg, (Throwable)e);
                    throw new RestoreSnapshotException(msg, e);
                }
                catch (IOException ex) {
                    String msg = "Failed to restore and rollback to snapshot=" + failSafeSnapshotSnapshotName;
                    LOG.error((Object)msg, (Throwable)ex);
                    throw new RestoreSnapshotException(msg, e);
                }
            }
            throw new RestoreSnapshotException("Failed to restore snapshot=" + snapshotName, e);
        }
        if (takeFailSafeSnapshot) {
            try {
                LOG.info((Object)("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
                this.deleteSnapshot(failSafeSnapshotSnapshotName);
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName), (Throwable)e);
            }
        }
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), TableName.valueOf((byte[])tableName));
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), tableName);
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        this.cloneSnapshot(snapshotName, TableName.valueOf((String)tableName));
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        if (this.checkIfMapRTable(tableName, true)) {
            throw new UnsupportedOperationException("cloneSnapshot called for a MapR Table.");
        }
        if (this.tableExists(tableName)) {
            throw new TableExistsException(tableName);
        }
        this.internalRestoreSnapshot(snapshotName, tableName);
        this.waitUntilTableIsEnabled(tableName);
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (String key : props.keySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(props.get(key)).build();
            builder.addConfiguration(pair);
        }
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(builder.build()).build();
        MasterProtos.ExecProcedureResponse response = this.executeCallable(new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection()){

            @Override
            public MasterProtos.ExecProcedureResponse call() throws ServiceException {
                return this.master.execProcedure(null, request);
            }
        });
        long start = EnvironmentEdgeManager.currentTimeMillis();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug((Object)("Waiting a max of " + max + " ms for procedure '" + signature + " : " + instance + "'' to complete. (max " + maxPauseTime + " ms per retry)"));
        boolean done = false;
        while (tries == 0 || EnvironmentEdgeManager.currentTimeMillis() - start < max && !done) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug((Object)("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for procedure completion."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted while waiting for procedure " + signature + " to complete"));
                Thread.currentThread().interrupt();
            }
            LOG.debug((Object)"Getting current status of procedure from master...");
            done = this.isProcedureFinished(signature, instance, props);
        }
        if (!done) {
            throw new IOException("Procedure '" + signature + " : " + instance + "' wasn't completed in expectedTime:" + max + " ms");
        }
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription.Builder builder = HBaseProtos.ProcedureDescription.newBuilder();
        builder.setSignature(signature).setInstance(instance);
        for (String key : props.keySet()) {
            HBaseProtos.NameStringPair pair = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(props.get(key)).build();
            builder.addConfiguration(pair);
        }
        final HBaseProtos.ProcedureDescription desc = builder.build();
        return this.executeCallable(new MasterCallable<MasterProtos.IsProcedureDoneResponse>(this.getConnection()){

            @Override
            public MasterProtos.IsProcedureDoneResponse call() throws ServiceException {
                return this.master.isProcedureDone(null, MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(desc).build());
            }
        }).getDone();
    }

    private void internalRestoreSnapshot(String snapshotName, TableName tableName) throws IOException, RestoreSnapshotException {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        this.internalRestoreSnapshotAsync(snapshot);
        final MasterProtos.IsRestoreSnapshotDoneRequest request = MasterProtos.IsRestoreSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsRestoreSnapshotDoneResponse done = MasterProtos.IsRestoreSnapshotDoneResponse.newBuilder().setDone(false).buildPartial();
        long maxPauseTime = 5000L;
        int tries = 0;
        while (!done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > 5000L ? 5000L : sleep;
                LOG.debug((Object)(tries + ") Sleeping: " + sleep + " ms while we wait for snapshot restore to complete."));
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Interrupted while waiting for snapshot " + snapshot + " restore to complete"));
                Thread.currentThread().interrupt();
            }
            LOG.debug((Object)"Getting current status of snapshot restore from master...");
            done = this.executeCallable(new MasterCallable<MasterProtos.IsRestoreSnapshotDoneResponse>(this.getConnection()){

                @Override
                public MasterProtos.IsRestoreSnapshotDoneResponse call() throws ServiceException {
                    return this.master.isRestoreSnapshotDone(null, request);
                }
            });
        }
        if (!done.getDone()) {
            throw new RestoreSnapshotException("Snapshot '" + snapshot.getName() + "' wasn't restored.");
        }
    }

    private MasterProtos.RestoreSnapshotResponse internalRestoreSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, RestoreSnapshotException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.RestoreSnapshotRequest request = MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return this.executeCallable(new MasterCallable<MasterProtos.RestoreSnapshotResponse>(this.getConnection()){

            @Override
            public MasterProtos.RestoreSnapshotResponse call() throws ServiceException {
                return this.master.restoreSnapshot(null, request);
            }
        });
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        this.ensureConnectedToHBase();
        return this.executeCallable(new MasterCallable<List<HBaseProtos.SnapshotDescription>>(this.getConnection()){

            @Override
            public List<HBaseProtos.SnapshotDescription> call() throws ServiceException {
                return this.master.getCompletedSnapshots(null, MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build()).getSnapshotsList();
            }
        });
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        LinkedList<HBaseProtos.SnapshotDescription> matched = new LinkedList<HBaseProtos.SnapshotDescription>();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots();
        for (HBaseProtos.SnapshotDescription snapshot : snapshots) {
            if (!pattern.matcher(snapshot.getName()).matches()) continue;
            matched.add(snapshot);
        }
        return matched;
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString((byte[])snapshotName));
    }

    public void deleteSnapshot(final String snapshotName) throws IOException {
        this.ensureConnectedToHBase();
        TableName.isLegalFullyQualifiedTableName((byte[])Bytes.toBytes((String)snapshotName));
        this.executeCallable(new MasterCallable<Void>(this.getConnection()){

            @Override
            public Void call() throws ServiceException {
                this.master.deleteSnapshot(null, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName).build()).build());
                return null;
            }
        });
    }

    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        this.ensureConnectedToHBase();
        List<HBaseProtos.SnapshotDescription> snapshots = this.listSnapshots(pattern);
        for (final HBaseProtos.SnapshotDescription snapshot : snapshots) {
            this.executeCallable(new MasterCallable<Void>(this.getConnection()){

                @Override
                public Void call() throws ServiceException {
                    this.master.deleteSnapshot(null, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(snapshot).build());
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V executeCallable(MasterCallable<V> callable) throws IOException {
        RpcRetryingCaller<V> caller = this.rpcCallerFactory.newCaller();
        try {
            Object t = caller.callWithRetries(callable);
            return (V)t;
        }
        finally {
            callable.close();
        }
    }

    public CoprocessorRpcChannel coprocessorService() {
        return new MasterCoprocessorRpcChannel(this.connection);
    }

    static abstract class MasterCallable<V>
    implements RetryingCallable<V>,
    Closeable {
        protected HConnection connection;
        protected MasterKeepAliveConnection master;

        public MasterCallable(HConnection connection) {
            this.connection = connection;
        }

        @Override
        public void prepare(boolean reload) throws IOException {
            this.master = this.connection.getKeepAliveMasterService();
        }

        @Override
        public void close() throws IOException {
            if (this.master != null) {
                this.master.close();
            }
        }

        @Override
        public void throwable(Throwable t, boolean retrying) {
        }

        @Override
        public String getExceptionMessageAdditionalDetail() {
            return "";
        }

        @Override
        public long sleep(long pause, int tries) {
            return ConnectionUtils.getPauseTime(pause, tries);
        }
    }

    abstract class HBaseConnector {
        HBaseConnector() {
        }

        abstract void connect() throws ZooKeeperConnectionException, MasterNotRunningException, IOException;
    }
}

