/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class UnmodifyableHTableDescriptor
extends HTableDescriptor {
    public UnmodifyableHTableDescriptor() {
    }

    public UnmodifyableHTableDescriptor(HTableDescriptor desc) {
        super(desc.getTableName(), UnmodifyableHTableDescriptor.getUnmodifyableFamilies(desc), desc.getValues());
    }

    private static HColumnDescriptor[] getUnmodifyableFamilies(HTableDescriptor desc) {
        HColumnDescriptor[] f = new HColumnDescriptor[desc.getFamilies().size()];
        int i = 0;
        for (HColumnDescriptor c : desc.getFamilies()) {
            f[i++] = c;
        }
        return f;
    }

    @Override
    public void addFamily(HColumnDescriptor family) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public HColumnDescriptor removeFamily(byte[] column) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public void setValue(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public void setValue(String key, String value) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public void setMaxFileSize(long maxFileSize) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }

    @Override
    public void setMemStoreFlushSize(long memstoreFlushSize) {
        throw new UnsupportedOperationException("HTableDescriptor is read-only");
    }
}

