/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSmallReversedScanner;
import org.apache.hadoop.hbase.client.ClientSmallScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestClientSmallReversedScanner {
    Scan scan;
    ExecutorService pool;
    Configuration conf;
    HConnection clusterConn;
    RpcRetryingCallerFactory rpcFactory;
    RpcControllerFactory controllerFactory;
    RpcRetryingCaller<Result[]> caller;

    @Before
    public void setup() throws IOException {
        this.clusterConn = (HConnection)Mockito.mock(HConnection.class);
        this.rpcFactory = (RpcRetryingCallerFactory)Mockito.mock(RpcRetryingCallerFactory.class);
        this.controllerFactory = (RpcControllerFactory)Mockito.mock(RpcControllerFactory.class);
        this.pool = Executors.newSingleThreadExecutor();
        this.scan = new Scan();
        this.conf = new Configuration();
        Mockito.when((Object)this.clusterConn.getConfiguration()).thenReturn((Object)this.conf);
        this.caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn(this.caller);
    }

    @After
    public void teardown() {
        if (null != this.pool) {
            this.pool.shutdownNow();
        }
    }

    private Answer<Boolean> createTrueThenFalseAnswer() {
        return new Answer<Boolean>(){
            boolean first = true;

            public Boolean answer(InvocationOnMock invocation) {
                if (this.first) {
                    this.first = false;
                    return true;
                }
                return false;
            }
        };
    }

    private ClientSmallScanner.SmallScannerCallableFactory getFactory(final RegionServerCallable<Result[]> callableWithReplicas) {
        return new ClientSmallScanner.SmallScannerCallableFactory(){

            public RegionServerCallable<Result[]> getCallable(Scan sc, HConnection connection, TableName table, byte[] localStartKey, int cacheNum, RpcControllerFactory rpcControllerFactory) {
                return callableWithReplicas;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextPresent() throws Exception {
        final KeyValue kv1 = new KeyValue("row1".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv3 = new KeyValue("row3".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        RegionServerCallable callableWithReplicas = (RegionServerCallable)Mockito.mock(RegionServerCallable.class);
        RpcRetryingCaller caller = (RpcRetryingCaller)Mockito.mock(RpcRetryingCaller.class);
        Mockito.when((Object)this.rpcFactory.newCaller()).thenReturn((Object)caller);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory((RegionServerCallable<Result[]>)callableWithReplicas);
        ClientSmallReversedScanner csrs = new ClientSmallReversedScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn);
        try {
            csrs.setRpcRetryingCaller(caller);
            csrs.setRpcControllerFactory(this.controllerFactory);
            csrs.setScannerCallableFactory(factory);
            Mockito.when((Object)caller.callWithRetries((RetryingCallable)callableWithReplicas, 60000)).thenAnswer((Answer)new Answer<Result[]>(){
                int count = 0;

                public Result[] answer(InvocationOnMock invocation) {
                    Result[] results = 0 == this.count ? new Result[]{Result.create((Cell[])new Cell[]{kv3}), Result.create((Cell[])new Cell[]{kv2})} : (1 == this.count ? new Result[]{Result.create((Cell[])new Cell[]{kv1})} : new Result[]{});
                    ++this.count;
                    return results;
                }
            });
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)true);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenAnswer(this.createTrueThenFalseAnswer());
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            csrs.loadCache();
            LinkedList results = csrs.cache;
            Iterator iter = results.iterator();
            Assert.assertEquals((long)3L, (long)results.size());
            for (int i = 3; i >= 1 && iter.hasNext(); --i) {
                Result result = (Result)iter.next();
                byte[] row = result.getRow();
                Assert.assertEquals((Object)("row" + i), (Object)new String(row, "UTF-8"));
                Assert.assertEquals((long)1L, (long)result.getMap().size());
            }
            Assert.assertTrue((boolean)csrs.closed);
        }
        finally {
            csrs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoContextFewerRecords() throws Exception {
        final KeyValue kv1 = new KeyValue("row1".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv2 = new KeyValue("row2".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        final KeyValue kv3 = new KeyValue("row3".getBytes(), "cf".getBytes(), "cq".getBytes(), 1L, KeyValue.Type.Maximum);
        RegionServerCallable callableWithReplicas = (RegionServerCallable)Mockito.mock(RegionServerCallable.class);
        this.scan.setCaching(2);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory((RegionServerCallable<Result[]>)callableWithReplicas);
        ClientSmallReversedScanner csrs = new ClientSmallReversedScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn);
        try {
            csrs.setRpcRetryingCaller(this.caller);
            csrs.setRpcControllerFactory(this.controllerFactory);
            csrs.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithRetries((RetryingCallable)callableWithReplicas, 60000)).thenAnswer((Answer)new Answer<Result[]>(){
                int count = 0;

                public Result[] answer(InvocationOnMock invocation) {
                    Result[] results;
                    if (0 == this.count) {
                        results = new Result[]{Result.create((Cell[])new Cell[]{kv3}), Result.create((Cell[])new Cell[]{kv2})};
                    } else if (1 == this.count) {
                        results = new Result[]{Result.create((Cell[])new Cell[]{kv1})};
                    } else {
                        throw new RuntimeException("Should not fetch a third batch from the server");
                    }
                    ++this.count;
                    return results;
                }
            });
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)false);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenThrow(new Throwable[]{new RuntimeException("Should not be called")});
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            csrs.loadCache();
            LinkedList results = csrs.cache;
            Iterator iter = results.iterator();
            Assert.assertEquals((long)2L, (long)results.size());
            for (int i = 3; i >= 2 && iter.hasNext(); --i) {
                Result result = (Result)iter.next();
                byte[] row = result.getRow();
                Assert.assertEquals((Object)("row" + i), (Object)new String(row, "UTF-8"));
                Assert.assertEquals((long)1L, (long)result.getMap().size());
            }
            results.clear();
            csrs.loadCache();
            Assert.assertEquals((long)1L, (long)results.size());
            Result result = (Result)results.get(0);
            Assert.assertEquals((Object)"row1", (Object)new String(result.getRow(), "UTF-8"));
            Assert.assertEquals((long)1L, (long)result.getMap().size());
            Assert.assertTrue((boolean)csrs.closed);
        }
        finally {
            csrs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoContextNoRecords() throws Exception {
        RegionServerCallable callableWithReplicas = (RegionServerCallable)Mockito.mock(RegionServerCallable.class);
        this.scan.setCaching(2);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory((RegionServerCallable<Result[]>)callableWithReplicas);
        ClientSmallReversedScanner csrs = new ClientSmallReversedScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn);
        try {
            csrs.setRpcRetryingCaller(this.caller);
            csrs.setRpcControllerFactory(this.controllerFactory);
            csrs.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithRetries((RetryingCallable)callableWithReplicas, 60000)).thenReturn((Object)new Result[0]);
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)false);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenThrow(new Throwable[]{new RuntimeException("Should not be called")});
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            csrs.loadCache();
            Assert.assertEquals((long)0L, (long)csrs.cache.size());
            Assert.assertTrue((boolean)csrs.closed);
        }
        finally {
            csrs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContextNoRecords() throws Exception {
        RegionServerCallable callableWithReplicas = (RegionServerCallable)Mockito.mock(RegionServerCallable.class);
        ClientSmallScanner.SmallScannerCallableFactory factory = this.getFactory((RegionServerCallable<Result[]>)callableWithReplicas);
        ClientSmallReversedScanner csrs = new ClientSmallReversedScanner(this.conf, this.scan, TableName.valueOf((String)"table"), this.clusterConn);
        try {
            csrs.setRpcRetryingCaller(this.caller);
            csrs.setRpcControllerFactory(this.controllerFactory);
            csrs.setScannerCallableFactory(factory);
            Mockito.when((Object)this.caller.callWithRetries((RetryingCallable)callableWithReplicas, 60000)).thenReturn((Object)new Result[0]);
            Mockito.when((Object)callableWithReplicas.hasMoreResultsContext()).thenReturn((Object)true);
            Mockito.when((Object)callableWithReplicas.getServerHasMoreResults()).thenReturn((Object)false);
            HRegionInfo regionInfo = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)callableWithReplicas.getHRegionInfo()).thenReturn((Object)regionInfo);
            Mockito.when((Object)regionInfo.getEndKey()).thenReturn((Object)HConstants.EMPTY_BYTE_ARRAY);
            csrs.loadCache();
            Assert.assertEquals((long)0L, (long)csrs.cache.size());
            Assert.assertTrue((boolean)csrs.closed);
        }
        finally {
            csrs.close();
        }
    }
}

